/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.sampler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.streaminer.stream.sampler.sre.OneSparseRecoveryEstimator;
import org.streaminer.stream.sampler.sre.SSparseRecoveryEstimator;
import org.streaminer.util.hash.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L0Sampler {
    private static Random rand = new Random();
    private int size;
    private int sparsity;
    private int k;
    private SSparseRecoveryEstimator[] levels;
    private Hash hasher;
    private Comparator<OneSparseRecoveryEstimator> sreComparator = new Comparator<OneSparseRecoveryEstimator>(){

        @Override
        public int compare(OneSparseRecoveryEstimator o1, OneSparseRecoveryEstimator o2) {
            int h2;
            int h1 = L0Sampler.this.hasher.hash(String.valueOf(o1.getIota() / o1.getPhi()));
            if (h1 < (h2 = L0Sampler.this.hasher.hash(String.valueOf(o2.getIota() / o2.getPhi())))) {
                return -1;
            }
            if (h1 > h2) {
                return 1;
            }
            return 0;
        }
    };

    public L0Sampler(int size, int sparsity, Hash hasher) {
        this.size = size;
        this.sparsity = sparsity;
        this.hasher = hasher;
        double delta = Math.pow(2.0, -sparsity / 12);
        this.k = (int)Math.round(Math.log((double)sparsity / delta) / Math.log(2.0));
        this.initialize();
    }

    public L0Sampler(int size, int sparsity, int k, Hash hasher) {
        this.size = size;
        this.sparsity = sparsity;
        this.k = k;
        this.hasher = hasher;
        this.initialize();
    }

    private void initialize() {
        int numLevels = (int)Math.round(Math.log(this.size) / Math.log(2.0));
        this.levels = new SSparseRecoveryEstimator[numLevels];
        for (int i = 0; i < numLevels; ++i) {
            this.levels[i] = new SSparseRecoveryEstimator(this.sparsity * 2, this.k, this.hasher);
        }
    }

    public int[] recover() {
        return this.recover(rand.nextInt(this.size));
    }

    public int[] recover(int i) {
        List<OneSparseRecoveryEstimator> vector = null;
        for (SSparseRecoveryEstimator level : this.levels) {
            if (level.isSSparse() && !(vector = level.recover()).isEmpty()) break;
        }
        if (vector != null && !vector.isEmpty()) {
            return this.select(vector);
        }
        return null;
    }

    public void update(int i, int value) {
        if (i <= 0 || i > this.size) {
            throw new IllegalArgumentException("Update value " + i + "outside size" + this.size);
        }
        for (int j = 0; j < this.levels.length; ++j) {
            if (!((double)this.size * Math.pow(2.0, -(j + 1)) >= (double)(this.hasher.hash(String.valueOf(i)) % this.size + 1))) continue;
            this.levels[j].update(i, value);
        }
    }

    public List<Integer[]> recursiveSelection() {
        int[] selection;
        ArrayList<Integer[]> sample = new ArrayList<Integer[]>();
        while ((selection = this.recover()) != null) {
            sample.add(new Integer[]{selection[0], selection[1]});
            this.update(selection[0], -selection[1]);
        }
        return sample;
    }

    private int[] select(List<OneSparseRecoveryEstimator> vector) {
        Collections.sort(vector, this.sreComparator);
        OneSparseRecoveryEstimator item = vector.get(0);
        int i = item.getIota() / item.getPhi();
        return new int[]{i, item.getPhi()};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("L0Sampler{levels=[");
        for (int i = 0; i < this.levels.length; ++i) {
            sb.append(String.format("level %d: %s", i, this.levels[i].toString()));
        }
        sb.append(String.format("], size=%d, sparsity=%d, k=%d}", this.size, this.sparsity, this.k));
        return sb.toString();
    }
}

