/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.sampler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.streaminer.stream.sampler.ISampleList;
import org.streaminer.stream.sampler.gamma.GammaFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservoirSampler<T>
implements ISampleList<T> {
    private static final Random RANDOM = new Random();
    private long skipCount;
    private int currentCount;
    private int size;
    private GammaFunction skipFunction;
    private List<T> items;

    public ReservoirSampler(int size, GammaFunction skipFunction) {
        this.items = new ArrayList<T>(size);
        this.size = size;
        this.currentCount = 0;
        this.skipCount = 0L;
        this.skipFunction = skipFunction;
    }

    @Override
    public void sample(T t) {
        if (this.size != this.items.size()) {
            this.items.add(t);
        } else if (this.skipCount > 0L) {
            --this.skipCount;
        } else {
            this.items.set(RANDOM.nextInt(this.size), t);
            this.skipCount = this.skipFunction.apply(this.currentCount);
        }
        ++this.currentCount;
    }

    @Override
    public void sample(T ... t) {
        for (T item : t) {
            this.sample(item);
        }
    }

    @Override
    public Collection<T> getSamples() {
        return Collections.unmodifiableCollection(this.items);
    }

    @Override
    public int getSize() {
        return this.size;
    }
}

