/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.sampler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.streaminer.stream.sampler.ISampleList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceSavingSampler<T>
implements ISampleList<T> {
    private int k;
    private Map<T, Integer> sample;

    public SpaceSavingSampler(int k) {
        this.k = k;
        this.sample = new HashMap<T, Integer>(k);
    }

    @Override
    public void sample(T item) {
        if (this.sample.containsKey(item)) {
            this.sample.put(item, this.sample.get(item) + 1);
        } else if (this.sample.size() < this.k) {
            this.sample.put(item, 1);
        } else {
            Map.Entry<T, Integer> min = this.getMin();
            this.sample.put(item, min.getValue() + 1);
            this.sample.remove(min.getKey());
        }
    }

    @Override
    public void sample(T ... t) {
        for (T item : t) {
            this.sample(item);
        }
    }

    @Override
    public Collection<T> getSamples() {
        return this.sample.keySet();
    }

    @Override
    public int getSize() {
        return this.sample.size();
    }

    private Map.Entry<T, Integer> getMin() {
        Map.Entry<T, Integer> min = null;
        for (Map.Entry<T, Integer> e : this.sample.entrySet()) {
            if (min != null && e.getValue() >= min.getValue()) continue;
            min = e;
        }
        return min;
    }
}

