/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.sampler;

import org.streaminer.stream.sampler.ISampler;

public class SystematicSampler
implements ISampler {
    private long period = 0L;
    private long counter = 0L;

    public SystematicSampler(long period) {
        if (period < 2L) {
            throw new IllegalArgumentException("period must be greater than 1");
        }
        this.period = period;
    }

    public boolean next() {
        boolean res = this.counter % this.period == 0L;
        ++this.counter;
        if (this.counter < 0L) {
            this.counter = 0L;
        }
        return res;
    }

    public void setSeed(long seed) {
        if (seed < 0L) {
            seed *= -1L;
        }
        this.counter = seed;
    }

    public void reset() {
        this.counter = 0L;
    }
}

