/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.sampler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.streaminer.stream.sampler.ISampleList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WRSampler<T>
implements ISampleList<T> {
    private static final Random rand = new Random();
    private List<T> sample;
    private int count = 0;
    private int sampleSize;

    public WRSampler(int sampleSize) {
        this.sampleSize = sampleSize;
        this.sample = new ArrayList<T>(sampleSize);
    }

    @Override
    public void sample(T item) {
        ++this.count;
        if (this.count <= this.sampleSize) {
            this.sample.add(item);
        } else if (rand.nextInt(this.count) < this.sampleSize) {
            this.sample.set(rand.nextInt(this.sampleSize), item);
        }
    }

    @Override
    public void sample(T ... items) {
        for (T item : items) {
            this.sample(item);
        }
    }

    @Override
    public Collection<T> getSamples() {
        return this.sample;
    }

    @Override
    public int getSize() {
        return this.sampleSize;
    }
}

