/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.sampler;

import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.streaminer.stream.sampler.ISampler;

public class WeightedRandomSampler
implements ISampler {
    private static final int UNDEFINED = -1;
    protected int skip;
    protected int nextTriggerPos;
    protected int nextSkip;
    protected int weight;
    protected RandomGenerator generator;

    public WeightedRandomSampler() {
        this(1, (RandomGenerator)new JDKRandomGenerator());
    }

    public WeightedRandomSampler(int weight, RandomGenerator generator) {
        this.generator = generator;
        this.setWeight(weight);
    }

    public boolean next() {
        if (this.skip > 0) {
            --this.skip;
            return false;
        }
        if (this.nextTriggerPos == -1) {
            this.nextTriggerPos = this.weight == 1 ? 0 : this.generator.nextInt(this.weight);
            this.nextSkip = this.weight - 1 - this.nextTriggerPos;
        }
        if (this.nextTriggerPos > 0) {
            --this.nextTriggerPos;
            return false;
        }
        this.nextTriggerPos = -1;
        this.skip = this.nextSkip;
        return true;
    }

    public void setSeed(long seed) {
        this.generator.setSeed(seed);
    }

    public final void setWeight(int weight) {
        if (weight < 1) {
            throw new IllegalArgumentException("Weight should be greater than 0");
        }
        this.weight = weight;
        this.skip = 0;
        this.nextTriggerPos = -1;
        this.nextSkip = 0;
    }
}

