/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.sampler.sre;

public class OneSparseRecoveryEstimator {
    private int iota;
    private int phi;
    private int tau;

    public void update(int index, int weight) {
        this.phi += weight;
        this.iota += weight * index;
        this.tau = (int)((double)this.tau + (double)weight * Math.pow(index, 2.0));
    }

    public boolean isOneSparseSimple(int index) {
        return this.iota / this.phi == index;
    }

    public boolean isOneSparseGanguly() {
        return (double)(this.phi * this.tau) == Math.pow(this.iota, 2.0);
    }

    public int getIota() {
        return this.iota;
    }

    public int getPhi() {
        return this.phi;
    }

    public int getTau() {
        return this.tau;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + this.iota;
        hash = 59 * hash + this.phi;
        hash = 59 * hash + this.tau;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OneSparseRecoveryEstimator other = (OneSparseRecoveryEstimator)obj;
        if (this.iota != other.iota) {
            return false;
        }
        if (this.phi != other.phi) {
            return false;
        }
        return this.tau == other.tau;
    }

    public String toString() {
        return "OneSparseRecoveryEstimator{iota=" + this.iota + ", phi=" + this.phi + ", tau=" + this.tau + ", isOneSparseGanguly=" + this.isOneSparseGanguly() + '}';
    }
}

