/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.sampler.sre;

import java.util.ArrayList;
import java.util.List;
import org.streaminer.stream.sampler.sre.OneSparseRecoveryEstimator;
import org.streaminer.util.hash.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSparseRecoveryEstimator {
    private int ncols;
    private int nrows;
    private Hash hasher;
    private OneSparseRecoveryEstimator[][] array;

    public SSparseRecoveryEstimator(int ncols, int nrows, Hash hasher) {
        this.ncols = ncols;
        this.nrows = nrows;
        this.hasher = hasher;
        this.array = new OneSparseRecoveryEstimator[nrows][ncols];
        for (int i = 0; i < nrows; ++i) {
            for (int j = 0; j < ncols; ++j) {
                this.array[i][j] = new OneSparseRecoveryEstimator();
            }
        }
    }

    public boolean isSSparse() {
        int sparsity = 0;
        int size = this.ncols * this.nrows;
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                if (this.array[i][j].getPhi() != 0) continue;
                ++sparsity;
            }
        }
        return sparsity >= this.ncols / 2 && sparsity != size;
    }

    public void update(int index, int value) {
        for (int row = 0; row < this.nrows; ++row) {
            int col = this.hash(index, row) % this.ncols;
            this.array[row][col].update(index, value);
        }
    }

    public List<OneSparseRecoveryEstimator> recover() {
        ArrayList<OneSparseRecoveryEstimator> aPrime = new ArrayList<OneSparseRecoveryEstimator>();
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                if (this.array[i][j].getPhi() == 0 || !this.array[i][j].isOneSparseGanguly()) continue;
                aPrime.add(this.array[i][j]);
            }
        }
        return aPrime;
    }

    protected int hash(int index, int seed) {
        return this.hasher.hash(String.valueOf(index).getBytes(), seed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SSparseRecoveryEstimator{array=[");
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                sb.append(String.format("(%d,%d)=%s, ", i, j, this.array[i][j].toString()));
            }
        }
        sb.append("]}");
        return sb.toString();
    }
}

