/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.stream.wavelet;

import org.streaminer.stream.wavelet.IWavelet;

public class HaarWaveletTransform
implements IWavelet {
    private int[] coeff;
    private int average;
    private int numLargest;
    private int dataSize;

    public HaarWaveletTransform(int numLargest) {
        this.numLargest = numLargest;
    }

    public HaarWaveletTransform(CompactHaarCoefficient compactCoeff, int dataSetSize) {
        this.average = compactCoeff.getAverage();
        this.coeff = compactCoeff.reconstructCoeff(dataSetSize);
        this.numLargest = compactCoeff.getCompactCoeff().length;
        this.dataSize = this.coeff.length + 1;
    }

    public void setNumLargest(int numLargest) {
        this.numLargest = numLargest;
    }

    public void transform(int[] data) {
        if (this.isMultipleOfTwo(data.length)) {
            this.coeff = new int[data.length - 1];
            this.findCoeff(data, this.coeff, 0);
            this.dataSize = data.length;
        }
    }

    public int[] untransform() {
        int[] data = new int[]{this.average};
        int coeffOffset = this.coeff.length - 1;
        data = this.getData(data, coeffOffset);
        return data;
    }

    public int[] getCoefficients() {
        return this.coeff;
    }

    public int getAverage() {
        return this.average;
    }

    public CompactHaarCoefficient getCompactTransform() {
        return new CompactHaarCoefficient(this.coeff, this.average, this.numLargest);
    }

    public boolean isMultipleOfTwo(int value) {
        int count = 0;
        for (int i = 0; i < 32; ++i) {
            if ((value & 1) == 1) {
                ++count;
            }
            value >>= 1;
        }
        return count == 1;
    }

    private int[] getData(int[] data, int coeffOffset) {
        int[] newData = new int[data.length * 2];
        int i = 0;
        int j = 0;
        int k = coeffOffset;
        while (i < data.length) {
            newData[j++] = data[i] + this.coeff[k];
            newData[j++] = data[i] - this.coeff[k];
            ++i;
            ++k;
        }
        if (newData.length < this.dataSize) {
            this.getData(newData, coeffOffset + data.length);
        }
        return newData;
    }

    private void findCoeff(int[] data, int[] coeff, int current) {
        int[] newData = new int[data.length / 2];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            newData[j] = data[i] + data[i + 1] >> 1;
            coeff[current++] = data[i] - data[i + 1] >> 1;
            i += 2;
            ++j;
        }
        if (newData.length > 1) {
            this.findCoeff(newData, coeff, current);
        } else {
            this.average = newData[0];
        }
    }

    public static class CompactHaarCoefficient {
        private int average;
        private int[] compactCoeff;
        private long coeffBitMap;

        public CompactHaarCoefficient(int[] coeff, int average, int numLargest) {
            this.average = average;
            int[] coeffCopy = new int[coeff.length];
            for (int i = 0; i < coeff.length; ++i) {
                coeffCopy[i] = Math.abs(coeff[i]);
            }
            int smallest = coeffCopy[coeff.length - numLargest - 1];
            this.compactCoeff = new int[numLargest];
            int j = 0;
            for (int i = 0; i < coeff.length; ++i) {
                if (Math.abs(coeff[i]) <= smallest) continue;
                this.compactCoeff[j++] = coeff[i];
                this.coeffBitMap |= (long)(1 << i);
            }
        }

        public CompactHaarCoefficient(String data) {
            String[] parts = data.split(",");
            this.average = Integer.parseInt(parts[0]);
            this.coeffBitMap = Long.parseLong(parts[1]);
            this.compactCoeff = new int[parts.length - 2];
            for (int i = 2; i < parts.length; ++i) {
                this.compactCoeff[i - 2] = Integer.parseInt(parts[i]);
            }
        }

        public String toString() {
            StringBuilder stBld = new StringBuilder();
            stBld.append(this.average).append(",").append(this.coeffBitMap);
            for (int i = 0; i < this.compactCoeff.length; ++i) {
                stBld.append(",").append(this.compactCoeff[i]);
            }
            return stBld.toString();
        }

        public int getAverage() {
            return this.average;
        }

        public int[] getCompactCoeff() {
            return this.compactCoeff;
        }

        public long getCoeffBitMap() {
            return this.coeffBitMap;
        }

        public int[] reconstructCoeff(int dataSetSize) {
            int[] coeff = new int[dataSetSize - 1];
            int j = 0;
            for (int i = 0; i < dataSetSize - 1; ++i) {
                coeff[i] = (this.coeffBitMap & (long)(1 << i)) == 1L ? this.compactCoeff[j++] : 0;
            }
            return coeff;
        }
    }
}

