/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.util;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeOf {
    private static OutputStream out = System.out;
    private static Instrumentation inst;
    private static long MIN_CLASS_SIZE_TO_LOG;
    private static boolean SKIP_STATIC_FIELD;
    private static boolean SKIP_FINAL_FIELD;
    private static boolean SKIP_FLYWEIGHT_FIELD;
    private static boolean debug;
    private static String[] unit;

    public static void premain(String options, Instrumentation inst) {
        SizeOf.inst = inst;
        System.out.println("JAVAGENT: call premain instrumentation for class SizeOf");
    }

    public static long sizeOf(Object object) {
        if (inst == null) {
            throw new IllegalStateException("Instrumentation is null");
        }
        if (SKIP_FLYWEIGHT_FIELD && SizeOf.isSharedFlyweight(object)) {
            return 0L;
        }
        return inst.getObjectSize(object);
    }

    public static String humanReadable(long size) {
        int i;
        double dSize = size;
        for (i = 0; i < 3 && !(dSize < 1024.0); dSize /= 1024.0, ++i) {
        }
        return dSize + unit[i];
    }

    public static long deepSizeOf(Object objectToSize) {
        IdentityHashMap<Object, Object> doneObj = new IdentityHashMap<Object, Object>();
        return SizeOf.deepSizeOf(objectToSize, doneObj, 0);
    }

    public static long iterativeSizeOf(Object objectToSize) throws IllegalArgumentException, IllegalAccessException, IOException {
        return SizeOf.deepSizeOf(objectToSize);
    }

    private static String indent(int depth) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            builder.append("  ");
        }
        return builder.toString();
    }

    private static long deepSizeOf(Object o, Map<Object, Object> doneObj, int depth) {
        if (o == null) {
            if (debug) {
                SizeOf.print("null\n");
            }
            return 0L;
        }
        long size = 0L;
        if (doneObj.containsKey(o)) {
            if (debug) {
                SizeOf.print("\n%s{ yet computed }\n", SizeOf.indent(depth));
            }
            return 0L;
        }
        if (debug) {
            SizeOf.print("\n%s{ %s\n", SizeOf.indent(depth), o.getClass().getName());
        }
        doneObj.put(o, null);
        size = SizeOf.sizeOf(o);
        if (o instanceof Object[]) {
            int i = 0;
            for (Object obj : (Object[])o) {
                if (debug) {
                    SizeOf.print("%s [%d] = ", SizeOf.indent(depth), i++);
                }
                size += SizeOf.deepSizeOf(obj, doneObj, depth + 1);
            }
        } else {
            Field[] fields;
            for (Field field : fields = o.getClass().getDeclaredFields()) {
                Object obj;
                field.setAccessible(true);
                try {
                    obj = field.get(o);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (SizeOf.isComputable(field)) {
                    if (debug) {
                        SizeOf.print("%s %s = ", SizeOf.indent(depth), field.getName());
                    }
                    size += SizeOf.deepSizeOf(obj, doneObj, depth + 1);
                    continue;
                }
                if (!debug) continue;
                SizeOf.print("%s %s = %s\n", SizeOf.indent(depth), field.getName(), obj.toString());
            }
        }
        if (debug) {
            SizeOf.print("%s} size = %s\n", SizeOf.indent(depth), SizeOf.humanReadable(size));
        }
        if (MIN_CLASS_SIZE_TO_LOG > 0L && size >= MIN_CLASS_SIZE_TO_LOG) {
            SizeOf.print("Found big object: %s%s@%s size: %s\n", SizeOf.indent(depth), o.getClass().getName(), System.identityHashCode(o), SizeOf.humanReadable(size));
        }
        return size;
    }

    private static boolean isAPrimitiveType(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return true;
        }
        if (clazz == Character.TYPE) {
            return true;
        }
        if (clazz == Byte.TYPE) {
            return true;
        }
        if (clazz == Short.TYPE) {
            return true;
        }
        if (clazz == Integer.TYPE) {
            return true;
        }
        if (clazz == Long.TYPE) {
            return true;
        }
        if (clazz == Float.TYPE) {
            return true;
        }
        if (clazz == Double.TYPE) {
            return true;
        }
        return clazz == Void.TYPE;
    }

    private static boolean isComputable(Field field) {
        int modificatori = field.getModifiers();
        if (SizeOf.isAPrimitiveType(field.getType())) {
            return false;
        }
        if (SKIP_STATIC_FIELD && Modifier.isStatic(modificatori)) {
            return false;
        }
        return !SKIP_FINAL_FIELD || !Modifier.isFinal(modificatori);
    }

    private static boolean isSharedFlyweight(Object obj) {
        if (obj instanceof Comparable) {
            if (obj instanceof Enum) {
                return true;
            }
            if (obj instanceof String) {
                return obj == ((String)obj).intern();
            }
            if (obj instanceof Boolean) {
                return obj == Boolean.TRUE || obj == Boolean.FALSE;
            }
            if (obj instanceof Integer) {
                return obj == Integer.valueOf((Integer)obj);
            }
            if (obj instanceof Short) {
                return obj == Short.valueOf((Short)obj);
            }
            if (obj instanceof Byte) {
                return obj == Byte.valueOf((Byte)obj);
            }
            if (obj instanceof Long) {
                return obj == Long.valueOf((Long)obj);
            }
            if (obj instanceof Character) {
                return obj == Character.valueOf(((Character)obj).charValue());
            }
        }
        return false;
    }

    public static void setMinSizeToLog(long min_class_size_to_log) {
        MIN_CLASS_SIZE_TO_LOG = min_class_size_to_log;
    }

    public static void skipFinalField(boolean skip_final_field) {
        SKIP_FINAL_FIELD = skip_final_field;
    }

    public static void skipStaticField(boolean skip_static_field) {
        SKIP_STATIC_FIELD = skip_static_field;
    }

    public static void skipFlyweightObject(boolean skip) {
        SKIP_FLYWEIGHT_FIELD = skip;
    }

    private static void print(String s) {
        try {
            out.write(s.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void print(String s, Object ... args) {
        try {
            out.write(String.format(s, args).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setLogOutputStream(OutputStream o) {
        if (o == null) {
            throw new IllegalArgumentException("Can't use a null OutputStream");
        }
        out = o;
    }

    public static void turnOnDebug() {
        debug = true;
    }

    public static void turnOffDebug() {
        debug = true;
    }

    static {
        MIN_CLASS_SIZE_TO_LOG = 0x100000L;
        SKIP_STATIC_FIELD = false;
        SKIP_FINAL_FIELD = false;
        SKIP_FLYWEIGHT_FIELD = false;
        debug = false;
        unit = new String[]{"b", "Kb", "Mb"};
    }
}

