/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class Varint {
    static byte[] byteArrayList = new byte[10];

    private Varint() {
    }

    public static void writeSignedVarLong(long value, DataOutput out) throws IOException {
        Varint.writeUnsignedVarLong(value << 1 ^ value >> 63, out);
    }

    public static void writeUnsignedVarLong(long value, DataOutput out) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte((int)value & 0x7F);
    }

    public static void writeSignedVarInt(int value, DataOutput out) throws IOException {
        Varint.writeUnsignedVarInt(value << 1 ^ value >> 31, out);
    }

    public static void writeUnsignedVarInt(int value, DataOutput out) throws IOException {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte(value & 0x7F);
    }

    public static byte[] writeSignedVarInt(int value) {
        return Varint.writeUnsignedVarInt(value << 1 ^ value >> 31);
    }

    public static byte[] writeUnsignedVarInt(int value) {
        int i = 0;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            Varint.byteArrayList[i++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
        Varint.byteArrayList[i] = (byte)(value & 0x7F);
        byte[] out = new byte[i + 1];
        while (i >= 0) {
            out[i] = byteArrayList[i];
            --i;
        }
        return out;
    }

    public static long readSignedVarLong(DataInput in) throws IOException {
        long raw = Varint.readUnsignedVarLong(in);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long readUnsignedVarLong(DataInput in) throws IOException {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)in.readByte()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IllegalArgumentException("Variable length quantity is too long");
        }
        return value | b << i;
    }

    public static int readSignedVarInt(DataInput in) throws IOException {
        int raw = Varint.readUnsignedVarInt(in);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static int readUnsignedVarInt(DataInput in) throws IOException {
        byte b;
        int value = 0;
        int i = 0;
        while (((b = in.readByte()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 35) continue;
            throw new IllegalArgumentException("Variable length quantity is too long");
        }
        return value | b << i;
    }

    public static int readSignedVarInt(byte[] bytes) {
        int raw = Varint.readUnsignedVarInt(bytes);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static int readUnsignedVarInt(byte[] bytes) {
        int value = 0;
        int i = 0;
        int rb = -128;
        byte[] arr$ = bytes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int b;
            rb = b = arr$[i$];
            if ((b & 0x80) == 0) break;
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 35) continue;
            throw new IllegalArgumentException("Variable length quantity is too long");
        }
        return value | rb << i;
    }
}

