/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.util.distance;

import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SquaredDistance {
    public static <T extends List<Double>> Double distanceBetween(T firstVector, T secondVector) {
        if (firstVector.size() != secondVector.size()) {
            throw new RuntimeException("Vectors must have the same dimension");
        }
        double distance = 0.0;
        for (int i = 0; i < firstVector.size(); ++i) {
            distance += Math.pow(firstVector.get(i) - secondVector.get(i), 2.0);
        }
        return Math.sqrt(distance);
    }

    public static <T extends List<Double>> T getFarestVector(List<T> vectors, T comparator) {
        double maximalDistance = Double.MIN_VALUE;
        int index = 0;
        for (int i = 0; i < vectors.size(); ++i) {
            if (!(SquaredDistance.distanceBetween((List)vectors.get(i), comparator) > maximalDistance)) continue;
            maximalDistance = SquaredDistance.distanceBetween((List)vectors.get(i), comparator);
            index = i;
        }
        return (T)((List)vectors.get(index));
    }

    public static <T extends List<Double>> T getNearestVector(List<T> vectors, T comparator) {
        double minimalDistance = Double.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < vectors.size(); ++i) {
            if (!(SquaredDistance.distanceBetween((List)vectors.get(i), comparator) < minimalDistance)) continue;
            minimalDistance = SquaredDistance.distanceBetween((List)vectors.get(i), comparator);
            index = i;
        }
        return (T)((List)vectors.get(index));
    }

    public static <T extends List<Double>> List<T> getPairWithSmallestDistance(List<T> vectors) {
        if (vectors.size() < 2) {
            throw new RuntimeException("List of vectors must at least contain two vectors");
        }
        LinkedList<List<Object>> bestPair = new LinkedList<List<Object>>();
        double minimalDistance = Double.MAX_VALUE;
        for (int i = 0; i < vectors.size() - 1; ++i) {
            List comparator = (List)vectors.get(i);
            for (int j = i + 1; j < vectors.size(); ++j) {
                if (!(SquaredDistance.distanceBetween(comparator, (List)vectors.get(j)) < minimalDistance)) continue;
                minimalDistance = SquaredDistance.distanceBetween(comparator, (List)vectors.get(j));
                bestPair = new LinkedList();
                bestPair.add(comparator);
                bestPair.add((List<Object>)vectors.get(j));
            }
        }
        return bestPair;
    }

    public static <T extends List<Double>> List<T> getPairWithFurthestDistance(List<T> vectors) {
        LinkedList<List<Object>> worstPair = new LinkedList<List<Object>>();
        double maximumDistance = Double.MIN_VALUE;
        for (int i = 0; i < vectors.size() - 1; ++i) {
            List comparator = (List)vectors.get(i);
            for (int j = i + 1; j < vectors.size(); ++j) {
                if (!(SquaredDistance.distanceBetween(comparator, (List)vectors.get(j)) > maximumDistance)) continue;
                maximumDistance = SquaredDistance.distanceBetween(comparator, (List)vectors.get(j));
                worstPair = new LinkedList();
                worstPair.add(comparator);
                worstPair.add((List<Object>)vectors.get(j));
            }
        }
        return worstPair;
    }
}

