/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.util.distribution;

import java.util.Random;

public class ZipfDistribution {
    private double theta;
    private double alpha;
    private double eta;
    private double zetan;
    private long n;
    private Random random = new Random();

    public ZipfDistribution(double theta, long n) {
        this(theta, n, n);
    }

    public ZipfDistribution(double theta, long n, long length) {
        this.theta = theta;
        this.n = n;
        this.alpha = 1.0 / (1.0 - theta);
        this.zetan = ZipfDistribution.zeta(length, theta);
        this.eta = (1.0 - Math.pow(2.0 / (double)n, 1.0 - theta)) / (1.0 - ZipfDistribution.zeta(2L, theta) / this.zetan);
    }

    public double nextDouble() {
        double u = this.random.nextDouble();
        double uz = u * this.zetan;
        double val = uz < 1.0 ? 1.0 : (uz < 1.0 + Math.pow(0.5, this.theta) ? 2.0 : (double)(1L + (long)((double)this.n * Math.pow(this.eta * u - this.eta + 1.0, this.alpha))));
        return val;
    }

    public static double zeta(long n, double theta) {
        double ans = 0.0;
        int i = 1;
        while ((long)i <= n) {
            ans += Math.pow(1.0 / (double)i, theta);
            ++i;
        }
        return ans;
    }
}

