/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.util.hash;

import java.io.UnsupportedEncodingException;
import org.streaminer.util.hash.MurmurHash;

public class HashUtils {
    public static final int MOD = Integer.MAX_VALUE;
    public static final int HL = 31;

    public static long hash31(long a, long b, long x) {
        long result = a * x + b;
        result = (result >> 31) + result & Integer.MAX_VALUE;
        return result;
    }

    public static long fourwise(long a, long b, long c, long d, long x) {
        long result = HashUtils.hash31(HashUtils.hash31(HashUtils.hash31(x, a, b), x, c), x, d);
        return result;
    }

    public static int[] getHashBuckets(String key, int hashCount, int max) {
        byte[] b;
        try {
            b = key.getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return HashUtils.getHashBuckets(b, hashCount, max);
    }

    static int[] getHashBuckets(byte[] b, int hashCount, int max) {
        int[] result = new int[hashCount];
        int hash1 = MurmurHash.getInstance().hash(b, b.length, 0);
        int hash2 = MurmurHash.getInstance().hash(b, b.length, hash1);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash1 + i * hash2) % max);
        }
        return result;
    }
}

