/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.util.hash;

import org.streaminer.util.hash.Hash;

public class JenkinsHash
extends Hash {
    private static long INT_MASK = 0xFFFFFFFFL;
    private static long BYTE_MASK = 255L;
    private static JenkinsHash _instance = new JenkinsHash();

    public static Hash getInstance() {
        return _instance;
    }

    public int hash(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof String) {
            return this.hash32(((String)o).getBytes());
        }
        if (o instanceof byte[]) {
            return this.hash32((byte[])o);
        }
        return this.hash32(o.toString().getBytes());
    }

    public long hash64(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof String) {
            return this.hash64(((String)o).getBytes());
        }
        if (o instanceof byte[]) {
            return this.hash64((byte[])o);
        }
        return this.hash64(o.toString().getBytes());
    }

    public long hash64(byte[] input) {
        int pc = 0;
        int pb = 0;
        return this.hash(input, input.length, pc, pb, false);
    }

    public int hash32(byte[] input) {
        int pc = 0;
        int pb = 0;
        return (int)this.hash(input, input.length, pc, pb, true);
    }

    private long hash(byte[] k, int length, int pc, int pb, boolean is32BitHash) {
        int c;
        int b = c = -559038737 + length + pc;
        int a = c;
        c += pb;
        int offset = 0;
        while (length > 12) {
            a += k[offset + 0];
            a += k[offset + 1] << 8;
            a += k[offset + 2] << 16;
            a += k[offset + 3] << 24;
            b += k[offset + 4];
            b += k[offset + 5] << 8;
            b += k[offset + 6] << 16;
            b += k[offset + 7] << 24;
            c += k[offset + 8];
            c += k[offset + 9] << 8;
            c += k[offset + 10] << 16;
            a -= (c += k[offset + 11] << 24);
            a = (int)((long)a ^ JenkinsHash.rot(c, 4));
            c += b;
            b -= a;
            b = (int)((long)b ^ JenkinsHash.rot(a, 6));
            a += c;
            c -= b;
            c = (int)((long)c ^ JenkinsHash.rot(b, 8));
            b += a;
            a -= c;
            a = (int)((long)a ^ JenkinsHash.rot(c, 16));
            c += b;
            b -= a;
            b = (int)((long)b ^ JenkinsHash.rot(a, 19));
            a += c;
            c -= b;
            c = (int)((long)c ^ JenkinsHash.rot(b, 4));
            b += a;
            length -= 12;
            offset += 12;
        }
        switch (length) {
            case 12: {
                c += k[offset + 11] << 24;
            }
            case 11: {
                c += k[offset + 10] << 16;
            }
            case 10: {
                c += k[offset + 9] << 8;
            }
            case 9: {
                c += k[offset + 8];
            }
            case 8: {
                b += k[offset + 7] << 24;
            }
            case 7: {
                b += k[offset + 6] << 16;
            }
            case 6: {
                b += k[offset + 5] << 8;
            }
            case 5: {
                b += k[offset + 4];
            }
            case 4: {
                a += k[offset + 3] << 24;
            }
            case 3: {
                a += k[offset + 2] << 16;
            }
            case 2: {
                a += k[offset + 1] << 8;
            }
            case 1: {
                a += k[offset + 0];
                break;
            }
            case 0: {
                return is32BitHash ? (long)c : (long)c | (long)(b << 32);
            }
        }
        c ^= b;
        c = (int)((long)c - JenkinsHash.rot(b, 14));
        a ^= c;
        a = (int)((long)a - JenkinsHash.rot(c, 11));
        b ^= a;
        b = (int)((long)b - JenkinsHash.rot(a, 25));
        c ^= b;
        c = (int)((long)c - JenkinsHash.rot(b, 16));
        a ^= c;
        a = (int)((long)a - JenkinsHash.rot(c, 4));
        b ^= a;
        b = (int)((long)b - JenkinsHash.rot(a, 14));
        c ^= b;
        c = (int)((long)c - JenkinsHash.rot(b, 24));
        return is32BitHash ? (long)c : (long)c | (long)(b << 32);
    }

    private static long rot(int x, int distance) {
        return x << distance | x >> 32 - distance;
    }

    private static long rot(long val, int pos) {
        return (long)Integer.rotateLeft((int)(val & INT_MASK), pos) & INT_MASK;
    }

    public int hash(byte[] key, int nbytes, int initval) {
        int length;
        long c;
        long b = c = 3735928559L + (long)length + (long)initval & INT_MASK;
        long a = c;
        int offset = 0;
        for (length = nbytes; length > 12; length -= 12) {
            a = a + ((long)key[offset + 0] & BYTE_MASK) & INT_MASK;
            a = a + (((long)key[offset + 1] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            a = a + (((long)key[offset + 2] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            a = a + (((long)key[offset + 3] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            b = b + ((long)key[offset + 4] & BYTE_MASK) & INT_MASK;
            b = b + (((long)key[offset + 5] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            b = b + (((long)key[offset + 6] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            b = b + (((long)key[offset + 7] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            c = c + ((long)key[offset + 8] & BYTE_MASK) & INT_MASK;
            c = c + (((long)key[offset + 9] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            c = c + (((long)key[offset + 10] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            c = c + (((long)key[offset + 11] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            a = a - c & INT_MASK;
            a ^= JenkinsHash.rot(c, 4);
            c = c + b & INT_MASK;
            b = b - a & INT_MASK;
            b ^= JenkinsHash.rot(a, 6);
            a = a + c & INT_MASK;
            c = c - b & INT_MASK;
            c ^= JenkinsHash.rot(b, 8);
            b = b + a & INT_MASK;
            a = a - c & INT_MASK;
            a ^= JenkinsHash.rot(c, 16);
            c = c + b & INT_MASK;
            b = b - a & INT_MASK;
            b ^= JenkinsHash.rot(a, 19);
            a = a + c & INT_MASK;
            c = c - b & INT_MASK;
            c ^= JenkinsHash.rot(b, 4);
            b = b + a & INT_MASK;
            offset += 12;
        }
        switch (length) {
            case 12: {
                c = c + (((long)key[offset + 11] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            }
            case 11: {
                c = c + (((long)key[offset + 10] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            }
            case 10: {
                c = c + (((long)key[offset + 9] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            }
            case 9: {
                c = c + ((long)key[offset + 8] & BYTE_MASK) & INT_MASK;
            }
            case 8: {
                b = b + (((long)key[offset + 7] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            }
            case 7: {
                b = b + (((long)key[offset + 6] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            }
            case 6: {
                b = b + (((long)key[offset + 5] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            }
            case 5: {
                b = b + ((long)key[offset + 4] & BYTE_MASK) & INT_MASK;
            }
            case 4: {
                a = a + (((long)key[offset + 3] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            }
            case 3: {
                a = a + (((long)key[offset + 2] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            }
            case 2: {
                a = a + (((long)key[offset + 1] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            }
            case 1: {
                a = a + ((long)key[offset + 0] & BYTE_MASK) & INT_MASK;
                break;
            }
            case 0: {
                return (int)(c & INT_MASK);
            }
        }
        c ^= b;
        c = c - JenkinsHash.rot(b, 14) & INT_MASK;
        a ^= c;
        a = a - JenkinsHash.rot(c, 11) & INT_MASK;
        b ^= a;
        b = b - JenkinsHash.rot(a, 25) & INT_MASK;
        c ^= b;
        c = c - JenkinsHash.rot(b, 16) & INT_MASK;
        a ^= c;
        a = a - JenkinsHash.rot(c, 4) & INT_MASK;
        b ^= a;
        b = b - JenkinsHash.rot(a, 14) & INT_MASK;
        c ^= b;
        c = c - JenkinsHash.rot(b, 24) & INT_MASK;
        return (int)(c & INT_MASK);
    }
}

