/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.util.hash;

import org.streaminer.util.hash.Hash;

public class MurmurHash
extends Hash {
    private static MurmurHash _instance = new MurmurHash();

    public static Hash getInstance() {
        return _instance;
    }

    public int hash(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Long) {
            return this.hashLong((Long)o);
        }
        if (o instanceof Integer) {
            return this.hashLong(((Integer)o).intValue());
        }
        if (o instanceof Double) {
            return this.hashLong(Double.doubleToRawLongBits((Double)o));
        }
        if (o instanceof Float) {
            return this.hashLong(Float.floatToRawIntBits(((Float)o).floatValue()));
        }
        if (o instanceof String) {
            return this.hash(((String)o).getBytes());
        }
        if (o instanceof byte[]) {
            return this.hash((byte[])o);
        }
        return this.hash(o.toString());
    }

    public int hash(byte[] data, int length, int seed) {
        int m = 1540483477;
        int r = 24;
        int h = seed ^ length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = i << 2;
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 0] & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            if (left >= 3) {
                h ^= data[length - 3] << 16;
            }
            if (left >= 2) {
                h ^= data[length - 2] << 8;
            }
            if (left >= 1) {
                h ^= data[length - 1];
            }
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    public int hashLong(long data) {
        int m = 1540483477;
        int r = 24;
        int h = 0;
        int k = (int)data * m;
        k ^= k >>> r;
        h ^= k * m;
        k = (int)(data >> 32) * m;
        k ^= k >>> r;
        h *= m;
        h ^= k * m;
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    public long hash64(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof String) {
            byte[] bytes = ((String)o).getBytes();
            return this.hash64(bytes, bytes.length);
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            return this.hash64(bytes, bytes.length);
        }
        return this.hash64(o.toString());
    }

    public long hash64(Object o, int seed) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof String) {
            byte[] bytes = ((String)o).getBytes();
            return this.hash64(bytes, bytes.length, seed);
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            return this.hash64(bytes, bytes.length, seed);
        }
        return this.hash64(o.toString(), seed);
    }

    public long hash64(byte[] data, int length) {
        return this.hash64(data, length, -512093083);
    }

    public long hash64(byte[] data, int length, int seed) {
        long m = -4132994306676758123L;
        int r = 47;
        long h = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int length8 = length / 8;
        for (int i = 0; i < length8; ++i) {
            int i8 = i * 8;
            long k = ((long)data[i8 + 0] & 0xFFL) + (((long)data[i8 + 1] & 0xFFL) << 8) + (((long)data[i8 + 2] & 0xFFL) << 16) + (((long)data[i8 + 3] & 0xFFL) << 24) + (((long)data[i8 + 4] & 0xFFL) << 32) + (((long)data[i8 + 5] & 0xFFL) << 40) + (((long)data[i8 + 6] & 0xFFL) << 48) + (((long)data[i8 + 7] & 0xFFL) << 56);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        switch (length % 8) {
            case 7: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 6] & 0xFF) << 48;
            }
            case 6: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 5] & 0xFF) << 40;
            }
            case 5: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 4] & 0xFF) << 32;
            }
            case 4: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 3] & 0xFF) << 24;
            }
            case 3: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= (long)(data[length & 0xFFFFFFF8] & 0xFF);
                h *= -4132994306676758123L;
            }
        }
        h ^= h >>> 47;
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        return h;
    }
}

