/*
 * Decompiled with CFR 0.152.
 */
package org.streaminer.util.hash.function;

import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.streaminer.util.hash.function.HashFunction;
import org.streaminer.util.math.Prime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoUniversalHashFunction<T>
implements HashFunction<T>,
Serializable {
    private static final long serialVersionUID = -5451250100120165585L;
    private final long coDomain;
    private final long prime;
    private final long a;
    private final long b;
    private final transient Map<T, Long> indices = new ConcurrentHashMap<T, Long>();
    private long lastIndex = 0L;

    public TwoUniversalHashFunction(int domain, int coDomain) {
        this.coDomain = coDomain;
        this.prime = Prime.getRandom(domain, 2L * (long)domain);
        Random rnd = new Random();
        long aTemp = 0L;
        while (aTemp == 0L) {
            aTemp = rnd.nextLong();
        }
        this.a = aTemp;
        this.b = -this.prime + (long)((int)(Math.random() * (double)(this.prime + this.prime + 1L)));
    }

    @Override
    public long hash(T x) {
        if (!this.indices.containsKey(x)) {
            this.indices.put(x, ++this.lastIndex);
        }
        long xi = this.indices.get(x);
        return Math.abs((this.a * xi + this.b) % this.prime % this.coDomain);
    }
}

