/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jetty;

import com.github.mjeanroy.junit.servers.commons.Strings;
import com.github.mjeanroy.junit.servers.exceptions.ServerInitializationException;
import com.github.mjeanroy.junit.servers.exceptions.ServerStartException;
import com.github.mjeanroy.junit.servers.exceptions.ServerStopException;
import com.github.mjeanroy.junit.servers.jetty.EmbeddedJettyConfiguration;
import com.github.mjeanroy.junit.servers.servers.AbstractEmbeddedServer;
import com.github.mjeanroy.junit.servers.servers.configuration.AbstractConfiguration;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import javax.servlet.ServletContext;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class EmbeddedJetty
extends AbstractEmbeddedServer<Server, EmbeddedJettyConfiguration> {
    private final Server server = this.initServer();
    private volatile WebAppContext webAppContext;
    private volatile ServerConnector connector;

    public EmbeddedJetty() {
        this(EmbeddedJettyConfiguration.defaultConfiguration());
    }

    public EmbeddedJetty(EmbeddedJettyConfiguration configuration) {
        super((AbstractConfiguration)configuration);
    }

    private Server initServer() {
        Server server = new Server(((EmbeddedJettyConfiguration)this.configuration).getPort());
        server.setStopAtShutdown(((EmbeddedJettyConfiguration)this.configuration).isStopAtShutdown());
        server.setStopTimeout((long)((EmbeddedJettyConfiguration)this.configuration).getStopTimeout());
        return server;
    }

    private WebAppContext initContext() {
        try {
            return this.createdWebAppContext();
        }
        catch (Exception ex) {
            throw new ServerInitializationException((Throwable)ex);
        }
    }

    public Server getDelegate() {
        return this.server;
    }

    protected void doStart() {
        try {
            this.webAppContext = this.initContext();
            this.server.start();
            this.connector = this.findConnector();
        }
        catch (Exception ex) {
            throw new ServerStartException((Throwable)ex);
        }
    }

    private WebAppContext createdWebAppContext() throws Exception {
        ClassLoader classLoader;
        String path = ((EmbeddedJettyConfiguration)this.configuration).getPath();
        String webapp = ((EmbeddedJettyConfiguration)this.configuration).getWebapp();
        String classpath = ((EmbeddedJettyConfiguration)this.configuration).getClasspath();
        Collection parentClasspath = ((EmbeddedJettyConfiguration)this.configuration).getParentClasspath();
        String overrideDescriptor = ((EmbeddedJettyConfiguration)this.configuration).getOverrideDescriptor();
        Resource baseResource = ((EmbeddedJettyConfiguration)this.configuration).getBaseResource();
        ClassLoader threadCl = Thread.currentThread().getContextClassLoader();
        if (!parentClasspath.isEmpty()) {
            int nbUrls = parentClasspath.size();
            URL[] urls = parentClasspath.toArray(new URL[nbUrls]);
            classLoader = new URLClassLoader(urls, threadCl);
        } else {
            classLoader = threadCl;
        }
        WebAppContext ctx = new WebAppContext();
        ctx.setClassLoader(classLoader);
        ctx.setContextPath(path);
        if (baseResource == null) {
            ctx.setBaseResource(Resource.newResource((String)webapp));
        } else {
            ctx.setBaseResource(baseResource);
        }
        if (overrideDescriptor != null) {
            ctx.setOverrideDescriptor(overrideDescriptor);
        }
        ctx.setConfigurations(new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration(), new AnnotationConfiguration(), new JettyWebXmlConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration()});
        if (Strings.isNotBlank((String)classpath)) {
            File classes = new File(classpath);
            PathResource containerResources = new PathResource(classes.toURI());
            ctx.getMetaData().addContainerResource((Resource)containerResources);
        }
        ctx.setParentLoaderPriority(true);
        ctx.setWar(webapp);
        ctx.setServer(this.server);
        this.server.setHandler((Handler)ctx);
        return ctx;
    }

    protected void doStop() {
        try {
            this.server.stop();
            this.webAppContext = null;
            this.connector = null;
        }
        catch (Exception ex) {
            throw new ServerStopException((Throwable)ex);
        }
    }

    public String getScheme() {
        return this.isStarted() ? this.server.getURI().getScheme() : super.getScheme();
    }

    public ServletContext getServletContext() {
        return this.webAppContext == null ? null : this.webAppContext.getServletContext();
    }

    protected int doGetPort() {
        return this.connector.getLocalPort();
    }

    private ServerConnector findConnector() {
        for (Connector connector : this.server.getConnectors()) {
            if (!(connector instanceof ServerConnector)) continue;
            return (ServerConnector)connector;
        }
        return null;
    }
}

