/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jetty;

import com.github.mjeanroy.junit.servers.commons.Preconditions;
import com.github.mjeanroy.junit.servers.commons.ToStringBuilder;
import com.github.mjeanroy.junit.servers.servers.configuration.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.configuration.AbstractConfigurationBuilder;
import java.util.Objects;
import org.eclipse.jetty.util.resource.Resource;

public class EmbeddedJettyConfiguration
extends AbstractConfiguration {
    private static final int DEFAULT_STOP_TIMEOUT = 30000;
    private static final boolean DEFAULT_STOP_AT_SHUTDOWN = true;
    private final int stopTimeout;
    private final boolean stopAtShutdown;
    private final Resource baseResource;

    public static Builder builder() {
        return new Builder();
    }

    public static EmbeddedJettyConfiguration defaultConfiguration() {
        return new Builder().build();
    }

    private EmbeddedJettyConfiguration(Builder builder) {
        super((AbstractConfigurationBuilder)builder);
        this.stopTimeout = builder.getStopTimeout();
        this.stopAtShutdown = builder.isStopAtShutdown();
        this.baseResource = builder.getBaseResource();
    }

    public int getStopTimeout() {
        return this.stopTimeout;
    }

    public boolean isStopAtShutdown() {
        return this.stopAtShutdown;
    }

    public Resource getBaseResource() {
        return this.baseResource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EmbeddedJettyConfiguration) {
            EmbeddedJettyConfiguration c = (EmbeddedJettyConfiguration)((Object)o);
            return c.canEqual((Object)this) && super.equals((Object)c) && Objects.equals(this.stopTimeout, c.stopTimeout) && Objects.equals(this.stopAtShutdown, c.stopAtShutdown) && Objects.equals(this.baseResource, c.baseResource);
        }
        return false;
    }

    protected boolean canEqual(Object o) {
        return o instanceof EmbeddedJettyConfiguration;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.stopTimeout, this.stopAtShutdown, this.baseResource);
    }

    public String toString() {
        return ToStringBuilder.create(((Object)((Object)this)).getClass()).append("port", Integer.valueOf(this.getPort())).append("path", this.getPath()).append("webapp", this.getWebapp()).append("classpath", this.getClasspath()).append("overrideDescriptor", this.getOverrideDescriptor()).append("parentClasspath", (Iterable)this.getParentClasspath()).append("stopTimeout", Integer.valueOf(this.stopTimeout)).append("stopAtShutdown", Boolean.valueOf(this.stopAtShutdown)).append("baseResource", (Object)this.baseResource).build();
    }

    public static class Builder
    extends AbstractConfigurationBuilder<Builder, EmbeddedJettyConfiguration> {
        private int stopTimeout = 30000;
        private boolean stopAtShutdown = true;
        private Resource baseResource;

        private Builder() {
        }

        protected Builder self() {
            return this;
        }

        public EmbeddedJettyConfiguration build() {
            return new EmbeddedJettyConfiguration(this);
        }

        public int getStopTimeout() {
            return this.stopTimeout;
        }

        public boolean isStopAtShutdown() {
            return this.stopAtShutdown;
        }

        public Resource getBaseResource() {
            return this.baseResource;
        }

        public Builder withStopTimeout(int stopTimeout) {
            this.stopTimeout = Preconditions.positive((int)stopTimeout, (String)"stopTimeout");
            return this;
        }

        public Builder disableStopAtShutdown() {
            return this.toggleStopAtShutdown(false);
        }

        public Builder enableStopAtShutdown() {
            return this.toggleStopAtShutdown(true);
        }

        private Builder toggleStopAtShutdown(boolean stopAtShutdown) {
            this.stopAtShutdown = stopAtShutdown;
            return this;
        }

        public Builder withBaseResource(Resource resource) {
            this.baseResource = resource;
            return this;
        }
    }
}

