/*
 * Decompiled with CFR 0.152.
 */
package mesosphere.marathon.client;

import feign.RequestLine;
import java.util.List;
import javax.inject.Named;
import mesosphere.marathon.client.model.v2.App;
import mesosphere.marathon.client.model.v2.DeleteAppTaskResponse;
import mesosphere.marathon.client.model.v2.DeleteAppTasksResponse;
import mesosphere.marathon.client.model.v2.Deployment;
import mesosphere.marathon.client.model.v2.GetAppResponse;
import mesosphere.marathon.client.model.v2.GetAppTasksResponse;
import mesosphere.marathon.client.model.v2.GetAppsResponse;
import mesosphere.marathon.client.model.v2.GetServerInfoResponse;
import mesosphere.marathon.client.model.v2.GetTasksResponse;
import mesosphere.marathon.client.model.v2.Group;
import mesosphere.marathon.client.model.v2.Result;
import mesosphere.marathon.client.utils.MarathonException;

public interface Marathon {
    @RequestLine(value="GET /v2/apps")
    public GetAppsResponse getApps();

    @RequestLine(value="GET /v2/apps/{id}")
    public GetAppResponse getApp(@Named(value="id") String var1) throws MarathonException;

    @RequestLine(value="GET /v2/apps/{id}/tasks")
    public GetAppTasksResponse getAppTasks(@Named(value="id") String var1);

    @RequestLine(value="GET /v2/tasks")
    public GetTasksResponse getTasks();

    @RequestLine(value="POST /v2/apps")
    public App createApp(App var1) throws MarathonException;

    @RequestLine(value="PUT /v2/apps/{app_id}")
    public void updateApp(@Named(value="app_id") String var1, App var2);

    @RequestLine(value="DELETE /v2/apps/{id}")
    public Result deleteApp(@Named(value="id") String var1) throws MarathonException;

    @RequestLine(value="DELETE /v2/apps/{app_id}/tasks?host={host}&scale={scale}")
    public DeleteAppTasksResponse deleteAppTasks(@Named(value="app_id") String var1, @Named(value="host") String var2, @Named(value="scale") String var3);

    @RequestLine(value="DELETE /v2/apps/{app_id}/tasks/{task_id}?scale={scale}")
    public DeleteAppTaskResponse deleteAppTask(@Named(value="app_id") String var1, @Named(value="task_id") String var2, @Named(value="scale") String var3);

    @RequestLine(value="POST /v2/groups")
    public Result createGroup(Group var1) throws MarathonException;

    @RequestLine(value="DELETE /v2/groups/{id}")
    public Result deleteGroup(@Named(value="id") String var1) throws MarathonException;

    @RequestLine(value="GET /v2/groups/{id}")
    public Group getGroup(@Named(value="id") String var1) throws MarathonException;

    @RequestLine(value="GET /v2/deployments")
    public List<Deployment> getDeployments();

    @RequestLine(value="DELETE /v2/deployments/{deploymentId}")
    public void cancelDeploymentAndRollback(@Named(value="deploymentId") String var1);

    @RequestLine(value="DELETE /v2/deployments/{deploymentId}?force=true")
    public void cancelDeployment(@Named(value="deploymentId") String var1);

    @RequestLine(value="GET /v2/info")
    public GetServerInfoResponse getServerInfo();
}

