/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.api.compute;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openstack4j.api.compute.ext.InstanceActionsService;
import org.openstack4j.api.compute.ext.InterfaceService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.Action;
import org.openstack4j.model.compute.RebootType;
import org.openstack4j.model.compute.Server;
import org.openstack4j.model.compute.ServerCreate;
import org.openstack4j.model.compute.ServerPassword;
import org.openstack4j.model.compute.ServerUpdateOptions;
import org.openstack4j.model.compute.VNCConsole;
import org.openstack4j.model.compute.VolumeAttachment;
import org.openstack4j.model.compute.actions.BackupOptions;
import org.openstack4j.model.compute.actions.EvacuateOptions;
import org.openstack4j.model.compute.actions.LiveMigrateOptions;
import org.openstack4j.model.compute.actions.RebuildOptions;
import org.openstack4j.model.compute.builder.ServerCreateBuilder;

public interface ServerService {
    public List<? extends Server> list();

    public List<? extends Server> list(boolean var1);

    public List<? extends Server> list(Map<String, String> var1);

    public List<? extends Server> listAll(boolean var1);

    public Server get(String var1);

    public Server boot(ServerCreate var1);

    public Server bootAndWaitActive(ServerCreate var1, int var2);

    public ActionResponse delete(String var1);

    public ActionResponse action(String var1, Action var2);

    public ActionResponse reboot(String var1, RebootType var2);

    public ActionResponse rebuild(String var1, RebuildOptions var2);

    public ActionResponse resize(String var1, String var2);

    public ActionResponse confirmResize(String var1);

    public ActionResponse revertResize(String var1);

    public String createSnapshot(String var1, String var2);

    public String createSnapshot(String var1, String var2, Map<String, String> var3);

    public ActionResponse addSecurityGroup(String var1, String var2);

    public ActionResponse removeSecurityGroup(String var1, String var2);

    public Map<String, ? extends Number> diagnostics(String var1);

    public ServerCreateBuilder serverBuilder();

    public String getConsoleOutput(String var1, int var2);

    public VNCConsole getVNCConsole(String var1, VNCConsole.Type var2);

    public VolumeAttachment attachVolume(String var1, String var2, String var3);

    public ActionResponse changeAdminPassword(String var1, String var2);

    public ActionResponse detachVolume(String var1, String var2);

    public ActionResponse migrateServer(String var1);

    public ActionResponse liveMigrate(String var1, LiveMigrateOptions var2);

    public ActionResponse resetState(String var1, Server.Status var2);

    public ActionResponse backupServer(String var1, BackupOptions var2);

    public Server waitForServerStatus(String var1, Server.Status var2, int var3, TimeUnit var4);

    public Map<String, String> getMetadata(String var1);

    public Map<String, String> updateMetadata(String var1, Map<String, String> var2);

    public ActionResponse deleteMetadataItem(String var1, String var2);

    public Server update(String var1, ServerUpdateOptions var2);

    public InterfaceService interfaces();

    public InstanceActionsService instanceActions();

    public ServerPassword getPassword(String var1);

    public ServerPassword evacuate(String var1, EvacuateOptions var2);
}

