/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.core.transport.internal;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.openstack4j.api.exceptions.ConnectorNotFoundException;
import org.openstack4j.api.exceptions.ResponseException;
import org.openstack4j.core.transport.HttpExecutorService;
import org.openstack4j.core.transport.HttpRequest;
import org.openstack4j.core.transport.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(HttpExecutor.class);
    private static final HttpExecutor INSTANCE = new HttpExecutor();
    private HttpExecutorService service;

    private HttpExecutor() {
    }

    public static HttpExecutor create() {
        return INSTANCE;
    }

    private HttpExecutorService service() {
        if (this.service != null) {
            return this.service;
        }
        Iterator<HttpExecutorService> it = ServiceLoader.load(HttpExecutorService.class, this.getClass().getClassLoader()).iterator();
        if (!it.hasNext()) {
            LOG.error("No OpenStack4j connector found in classpath, see https://github.com/ContainX/openstack4j/issues/832");
            throw new ConnectorNotFoundException("No OpenStack4j connector found in classpath, see https://github.com/ContainX/openstack4j/issues/832");
        }
        this.service = it.next();
        return this.service;
    }

    public String getExecutorName() {
        return this.service().getExecutorDisplayName();
    }

    public <R> HttpResponse execute(HttpRequest<R> request) {
        LOG.debug("Executing Request: {} {}", (Object)request.getMethod(), (Object)request.getUrl());
        try {
            return this.service().execute(request);
        }
        catch (ResponseException ex) {
            ex.setRequestInfo(request);
            throw ex;
        }
    }
}

