/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.telemetry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Map;
import org.openstack4j.common.Buildable;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.BasicResource;
import org.openstack4j.model.telemetry.builder.AlarmBuilder;
import org.openstack4j.openstack.telemetry.domain.CeilometerAlarm;

public interface Alarm
extends ModelEntity,
BasicResource,
Buildable<AlarmBuilder> {
    public List<String> getAlarmActions();

    public void setAlarmActions(List<String> var1);

    public String getAlarmId();

    public String getDescription();

    public void setDescription(String var1);

    public boolean isEnabled();

    public void isEnabled(boolean var1);

    public List<String> getInsufficientDataActions();

    public void setInsufficientDataActions(List<String> var1);

    @Override
    public String getName();

    @Override
    public void setName(String var1);

    public List<String> getOkActions();

    public void setOkActions(List<String> var1);

    public String getProjectId();

    public boolean getRepeatActions();

    public String getState();

    public String getStateTimestamp();

    public ThresholdRule getThresholdRule();

    public void setThresholdRule(CeilometerAlarm.CeilometerThresholdRule var1);

    public CombinationRule getCombinationRule();

    public Map<String, Object> getCompositeRule();

    public GnocchiResourcesThresholdRule getGnocchiResourcesThresholdRule();

    public void setGnocchiResourcesThresholdRule(CeilometerAlarm.CeilometerGnocchiResourcesThresholdRule var1);

    public GnocchiAggregationByMetricsThresholdRule getGnocchiAggregationByMetricsThresholdRule();

    public void setGnocchiAggregationByMetricsThresholdRule(CeilometerAlarm.CeilometerGnocchiAggregationByMetricsThresholdRule var1);

    public GnocchiAggregationByResourcesThresholdRule getGnocchiAggregationByResourcesThresholdRule();

    public void setGnocchiAggregationByResourcesThresholdRule(CeilometerAlarm.CeilometerGnocchiAggregationByResourcesThresholdRule var1);

    public String getTimestamp();

    public Type getType();

    public void setType(Type var1);

    public String getUserId();

    public void setUserId(String var1);

    public void setRepeateActions(Boolean var1);

    public static interface AlarmChange {
        public String getAlarmId();

        public void setAlarmId(String var1);

        public String getDetail();

        public void setDetail(String var1);

        public String getEventId();

        public void setEventId(String var1);

        public String getOnBehalfOf();

        public void setOnBehalfOf(String var1);

        public String getProjectId();

        public void setProjectId(String var1);

        public String getTimestamp();

        public void setTimestamp(String var1);

        public ChangeType getChangeType();

        public void setChangeType(ChangeType var1);

        public String getUserId();

        public void setUserId(String var1);

        public static enum ChangeType {
            CREATION,
            RULE_CHANGE,
            STATE_TRANSITION,
            DELETION,
            UNRECOGNIZED;


            @JsonCreator
            public static ChangeType fromValue(String type) {
                try {
                    return ChangeType.valueOf(type.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return UNRECOGNIZED;
                }
            }

            @JsonValue
            public String value() {
                return this.name().toLowerCase();
            }

            public String toString() {
                return this.value();
            }
        }
    }

    public static interface AlarmTimeConstraint {
        public String getDescription();

        public void setDescription(String var1);

        public int getDuration();

        public void setDuration(int var1);

        public String getName();

        public void setName(String var1);

        public String getStart();

        public void setStart(String var1);

        public String getTimezone();

        public void setTimezone(String var1);
    }

    public static interface AggregationMetricsByIdLookupRule {
        public String getMetric();

        public void setMetric(String var1);
    }

    public static interface AggregationMetricByResourcesLookupRule {
        public String getMetric();

        public void setMetric(String var1);

        public String getResourceType();

        public void setResourceType(String var1);
    }

    public static interface MetricOfResourceRule {
        public String getMetric();

        public void setMetric(String var1);

        public String getResourceId();

        public void setResourceId(String var1);

        public String getResourceType();

        public void setResourceType(String var1);
    }

    public static interface GnocchiEvent {
    }

    public static interface GnocchiAggregationByResourcesThresholdRule {
        public String getMetric();

        public void setMetric(String var1);

        public String getResourceType();

        public void setResourceType(String var1);

        public ComparisonOperator getComparisonOperator();

        public void setComparisonOperator(ComparisonOperator var1);

        public AggregationMethod getAggregationMethod();

        public void setAggregationMethod(AggregationMethod var1);

        public int getEvaluationPeriods();

        public void setEvaluationPeriods(int var1);

        public float getThreshold();

        public void setThreshold(float var1);

        public long getGranularity();

        public void setGranularity(long var1);

        public Query getQuery();

        public void setQuery(CeilometerAlarm.CeilometerQuery var1);
    }

    public static interface GnocchiAggregationByMetricsThresholdRule {
        public List<String> getMetrics();

        public void setMetrics(List<String> var1);

        public ComparisonOperator getComparisonOperator();

        public void setComparisonOperator(ComparisonOperator var1);

        public AggregationMethod getAggregationMethod();

        public void setAggregationMethod(AggregationMethod var1);

        public float getThreshold();

        public void setThreshold(float var1);

        public int getEvaluationPeriods();

        public void setEvaluationPeriods(int var1);

        public long getGranularity();

        public void setGranularity(long var1);
    }

    public static interface GnocchiResourcesThresholdRule {
        public String getMetric();

        public void setMetric(String var1);

        public String getResourceId();

        public void setResourceId(String var1);

        public String getResourceType();

        public void setResourceType(String var1);

        public ComparisonOperator getComparisonOperator();

        public void setComparisonOperator(ComparisonOperator var1);

        public AggregationMethod getAggregationMethod();

        public void setAggregationMethod(AggregationMethod var1);

        public int getEvaluationPeriods();

        public void setEvaluationPeriods(int var1);

        public float getThreshold();

        public void setThreshold(float var1);

        public long getGranularity();

        public void setGranularity(long var1);
    }

    public static interface Query {
        public String getField();

        public void setField(String var1);

        public String getValue();

        public void setValue(String var1);

        public ComparisonOperator getOp();

        public void setOp(ComparisonOperator var1);
    }

    public static interface ThresholdRule {
        public String getMeterName();

        public void setMeterName(String var1);

        public int getEvaluationPeriods();

        public void setEvaluationPeriods(int var1);

        public Statistic getStatistic();

        public void setStatistic(Statistic var1);

        public int getPeriod();

        public void setPeriod(int var1);

        public float getThreshold();

        public void setThreshold(float var1);

        public List<? extends Query> getQuery();

        public void setQuery(List<CeilometerAlarm.CeilometerQuery> var1);

        public ComparisonOperator getComparisonOperator();

        public void setComparisonOperator(ComparisonOperator var1);

        public boolean getExcludeOutliers();

        public void setExcludeOutliers(boolean var1);
    }

    public static interface CombinationRule {
        public List<String> getAlarmIds();

        public void setAlarmIds(List<String> var1);

        public Operator getOperator();

        public void setOperator(Operator var1);
    }

    public static enum AggregationMethod {
        COUNT,
        MAX,
        SUM,
        MIN,
        MEAN,
        UNRECOGNIZED;


        @JsonCreator
        public static AggregationMethod fromValue(String method) {
            try {
                return AggregationMethod.valueOf(method.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }
    }

    public static enum Operator {
        AND,
        OR,
        UNRECOGNIZED;


        @JsonCreator
        public static Operator fromValue(String operator) {
            try {
                return Operator.valueOf(operator.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }
    }

    public static enum ComparisonOperator {
        LT,
        LE,
        EQ,
        NE,
        GE,
        GT,
        UNRECOGNIZED;


        @JsonCreator
        public static ComparisonOperator fromValue(String operator) {
            try {
                return ComparisonOperator.valueOf(operator.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }
    }

    public static enum Statistic {
        MAX,
        MIN,
        AVG,
        SUM,
        COUNT,
        UNRECOGNIZED;


        @JsonCreator
        public static Statistic fromValue(String statistic) {
            try {
                return Statistic.valueOf(statistic.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }
    }

    public static enum Type {
        GNOCCHI_AGGREGATION_BY_METRICS_THRESHOLD,
        COMPOSITE,
        GNOCCHI_RESOURCES_THRESHOLD,
        GNOCCHI_AGGREGATION_BY_RESOURCES_THRESHOLD,
        THRESHOLD,
        EVENT,
        COMBINATION,
        UNRECOGNIZED;


        @JsonCreator
        public static Type fromValue(String type) {
            try {
                return Type.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }
    }
}

