/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.telemetry;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openstack4j.openstack.internal.Parser;

public class EventCriteria {
    private List<NameOpValue> params = new ArrayList<NameOpValue>();

    public static EventCriteria create() {
        return new EventCriteria();
    }

    public EventCriteria eventType(String eventType) {
        Objects.requireNonNull(eventType, "eventType must not be null");
        return this.add("event_type", Oper.EQUALS, eventType);
    }

    public EventCriteria messageId(String messageId) {
        Objects.requireNonNull(messageId, "messageId must not be null");
        return this.add("message_id", Oper.EQUALS, messageId);
    }

    public EventCriteria startTimestamp(Oper operator, Date value) {
        Objects.requireNonNull(value, "Date must not be null");
        return this.add("start_timestamp", operator, Parser.toISO8601DateFormat(value));
    }

    public EventCriteria endTimestamp(Oper operator, Date value) {
        Objects.requireNonNull(value, "Date must not be null");
        return this.add("end_timestamp", operator, Parser.toISO8601DateFormat(value));
    }

    public EventCriteria add(String field, Oper operator, Number value) {
        Objects.requireNonNull(value, "Value must not be null");
        return this.add(field, operator, value.toString());
    }

    public EventCriteria add(String field, Oper operator, String value) {
        Objects.requireNonNull(field, "Field must not be null");
        Objects.requireNonNull(operator, "Operator must not be null");
        Objects.requireNonNull(value, "Value must not be null");
        this.params.add(new NameOpValue(field, operator, (Comparable<?>)((Object)value)));
        return this;
    }

    public List<NameOpValue> getCriteriaParams() {
        return this.params;
    }

    public static class NameOpValue {
        private final String field;
        private final Oper operator;
        private String value;

        NameOpValue(String field, Oper operator, Comparable<?> value) {
            this.field = field;
            this.operator = operator;
            this.value = value instanceof Date ? Parser.toISO8601DateFormat((Date)Date.class.cast(value)) : String.valueOf(value);
        }

        public String getField() {
            return this.field;
        }

        public Oper getOperator() {
            return this.operator;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Oper {
        LT("lt"),
        GT("gt"),
        LTE("le"),
        GTE("ge"),
        EQUALS("eq");

        private final String queryValue;

        private Oper(String queryValue) {
            this.queryValue = queryValue;
        }

        public String getQueryValue() {
            return this.queryValue;
        }
    }
}

