/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.telemetry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openstack4j.model.ModelEntity;

public interface Meter
extends ModelEntity {
    public String getId();

    public String getName();

    public String getResourceId();

    public String getProjectId();

    public Type getType();

    public String getUnit();

    public String getUserId();

    public static enum Type {
        GAUGE,
        DELTA,
        CUMULATIVE,
        UNRECOGNIZED;


        @JsonCreator
        public static Type fromValue(String type) {
            try {
                return Type.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }
    }
}

