/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.barbican.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.openstack4j.model.barbican.ContainerSecret;
import org.openstack4j.model.barbican.builder.ContainerSecretBuilder;
import org.openstack4j.util.ToStringHelper;

public class BarbicanContainerSecret
implements ContainerSecret {
    private String name;
    @JsonProperty(value="secret_ref")
    private String reference;

    public static ContainerSecretBuilder builder() {
        return new SecretConcreteBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    public String toString() {
        return new ToStringHelper(this).add("name", this.name).add("reference", this.reference).toString();
    }

    @Override
    public ContainerSecretBuilder toBuilder() {
        return new SecretConcreteBuilder();
    }

    public static class SecretConcreteBuilder
    implements ContainerSecretBuilder {
        private BarbicanContainerSecret internalSecret;

        public SecretConcreteBuilder() {
            this(new BarbicanContainerSecret());
        }

        public SecretConcreteBuilder(BarbicanContainerSecret secret) {
            this.internalSecret = secret;
        }

        @Override
        public ContainerSecret build() {
            return this.internalSecret;
        }

        @Override
        public ContainerSecretBuilder from(ContainerSecret in) {
            this.internalSecret = (BarbicanContainerSecret)in;
            return this;
        }

        @Override
        public ContainerSecretBuilder name(String name) {
            this.internalSecret.name = name;
            return this;
        }

        @Override
        public ContainerSecretBuilder reference(String ref) {
            this.internalSecret.reference = ref;
            return this;
        }
    }
}

