/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.common;

import org.openstack4j.model.common.Link;
import org.openstack4j.model.common.builder.LinkBuilder;
import org.openstack4j.util.ToStringHelper;

public class GenericLink
implements Link {
    private static final long serialVersionUID = 1L;
    private String rel;
    private String href;
    private String type;

    public GenericLink() {
    }

    public GenericLink(String rel, String href, String type) {
        this.rel = rel;
        this.type = type;
        this.href = href;
    }

    public static LinkBuilder builder() {
        return new LinkConcreteBuilder();
    }

    @Override
    public LinkBuilder toBuilder() {
        return new LinkConcreteBuilder(this);
    }

    @Override
    public String getRel() {
        return this.rel;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return new ToStringHelper(this).add("href", this.href).add("rel", this.rel).add("type", this.type).toString();
    }

    public static class LinkConcreteBuilder
    implements LinkBuilder {
        GenericLink model;

        LinkConcreteBuilder() {
            this(new GenericLink());
        }

        LinkConcreteBuilder(GenericLink link) {
            this.model = link;
        }

        @Override
        public LinkConcreteBuilder rel(String rel) {
            this.model.rel = rel;
            return this;
        }

        @Override
        public LinkConcreteBuilder href(String href) {
            this.model.href = href;
            return this;
        }

        @Override
        public LinkConcreteBuilder type(String type) {
            this.model.type = type;
            return this;
        }

        @Override
        public Link build() {
            return this.model;
        }

        @Override
        public LinkBuilder from(Link in) {
            this.model = (GenericLink)in;
            return this;
        }
    }
}

