/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.compute.ext.ServicesService;
import org.openstack4j.model.compute.ext.Service;
import org.openstack4j.openstack.compute.domain.ext.ExtService;
import org.openstack4j.openstack.compute.internal.BaseComputeServices;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.manila.domain.actions.ServiceAction;
import org.openstack4j.openstack.manila.domain.actions.ServiceActions;

public class ServicesServiceImpl
extends BaseComputeServices
implements ServicesService {
    @Override
    public List<? extends Service> list() {
        return this.get(ExtService.Services.class, this.uri("/os-services", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Service> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<ExtService.Services> req = this.get(ExtService.Services.class, this.uri("/os-services", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public ExtService enableService(String binary, String host) {
        Objects.requireNonNull(binary);
        Objects.requireNonNull(host);
        return this.put(ExtService.class, this.uri("/os-services/enable", new Object[0])).entity(ServiceAction.enable(binary, host)).execute();
    }

    @Override
    public ExtService disableService(String binary, String host) {
        Objects.requireNonNull(binary);
        Objects.requireNonNull(host);
        return this.put(ExtService.class, this.uri("/os-services/disable", new Object[0])).entity(ServiceAction.disable(binary, host)).execute();
    }

    @Override
    public ExtService forceDownService(String binary, String host) {
        Objects.requireNonNull(binary);
        Objects.requireNonNull(host);
        return this.put(ExtService.class, this.uri("/os-services/force-down", new Object[0])).header("x-openstack-nova-api-version", "2.11").entity(ServiceActions.forceDown(binary, host)).execute();
    }

    @Override
    public ExtService forceUpService(String binary, String host) {
        Objects.requireNonNull(binary);
        Objects.requireNonNull(host);
        return this.put(ExtService.class, this.uri("/os-services/force-down", new Object[0])).header("x-openstack-nova-api-version", "2.11").entity(ServiceActions.forceUp(binary, host)).execute();
    }
}

