/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.gbp.NetworkPolicyService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.gbp.NetworkServicePolicy;
import org.openstack4j.openstack.gbp.domain.GbpNetworkServicePolicy;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class NetworkPolicyServiceImpl
extends BaseNetworkingServices
implements NetworkPolicyService {
    @Override
    public List<? extends NetworkServicePolicy> list() {
        return this.get(GbpNetworkServicePolicy.NetworkServicePolicies.class, this.uri("/grouppolicy/network_service_policies", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends NetworkServicePolicy> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpNetworkServicePolicy.NetworkServicePolicies> natpoolInvocation = this.buildInvocation(filteringParams);
        return natpoolInvocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<GbpNetworkServicePolicy.NetworkServicePolicies> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpNetworkServicePolicy.NetworkServicePolicies> servicePoliciesInvocation = this.get(GbpNetworkServicePolicy.NetworkServicePolicies.class, "/grouppolicy/network_service_policies");
        if (filteringParams == null) {
            return servicePoliciesInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                servicePoliciesInvocation = servicePoliciesInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return servicePoliciesInvocation;
    }

    @Override
    public NetworkServicePolicy get(String id) {
        Objects.requireNonNull(id);
        return this.get(GbpNetworkServicePolicy.class, this.uri("/grouppolicy/network_service_policies/%s", id)).execute();
    }

    @Override
    public GbpNetworkServicePolicy create(NetworkServicePolicy gbpServicePolicy) {
        return this.post(GbpNetworkServicePolicy.class, this.uri("/grouppolicy/network_service_policies", new Object[0])).entity(gbpServicePolicy).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Objects.requireNonNull(id);
        return this.deleteWithResponse(this.uri("/grouppolicy/network_service_policies/%s", id)).execute();
    }

    @Override
    public NetworkServicePolicy update(String gbpServicePolicyId, NetworkServicePolicy gbpServicePolicy) {
        Objects.requireNonNull(gbpServicePolicy);
        Objects.requireNonNull(gbpServicePolicyId);
        return this.put(GbpNetworkServicePolicy.class, this.uri("/grouppolicy/network_service_policies/%s", gbpServicePolicyId)).entity(gbpServicePolicy).execute();
    }
}

