/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.heat.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import org.openstack4j.model.heat.Template;
import org.openstack4j.model.heat.builder.TemplateBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HeatTemplate
implements Template {
    private static final long serialVersionUID = 4056106815634314225L;
    @JsonRawValue
    @JsonProperty(value="template")
    private String templateJson;
    @JsonProperty(value="template_url")
    private String templateURL;

    public static HeatTemplateConcreteBuilder build() {
        return new HeatTemplateConcreteBuilder();
    }

    @Override
    public String getTemplateJson() {
        return this.templateJson;
    }

    @Override
    public String getTemplateURL() {
        return this.templateURL;
    }

    @Override
    public TemplateBuilder toBuilder() {
        return new HeatTemplateConcreteBuilder(this);
    }

    public static class HeatTemplateConcreteBuilder
    implements TemplateBuilder {
        HeatTemplate model;

        public HeatTemplateConcreteBuilder() {
            this(new HeatTemplate());
        }

        public HeatTemplateConcreteBuilder(HeatTemplate template) {
            this.model = template;
        }

        @Override
        public Template build() {
            return this.model;
        }

        @Override
        public TemplateBuilder from(Template in) {
            this.model = (HeatTemplate)in;
            return this;
        }

        @Override
        public TemplateBuilder templateJson(String template) {
            this.model.templateJson = template;
            return this;
        }

        @Override
        public TemplateBuilder templateURL(String templateURL) {
            this.model.templateURL = templateURL;
            return this;
        }
    }
}

