/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.heat.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.api.Builders;
import org.openstack4j.api.heat.StackService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.heat.AdoptStackData;
import org.openstack4j.model.heat.Stack;
import org.openstack4j.model.heat.StackCreate;
import org.openstack4j.model.heat.StackUpdate;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.heat.domain.HeatAdoptStackData;
import org.openstack4j.openstack.heat.domain.HeatStack;
import org.openstack4j.openstack.heat.domain.HeatStackAdopt;
import org.openstack4j.openstack.heat.internal.BaseHeatServices;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class StackServiceImpl
extends BaseHeatServices
implements StackService {
    @Override
    public Stack create(StackCreate newStack) {
        Objects.requireNonNull(newStack);
        return this.post(HeatStack.class, this.uri("/stacks", new Object[0])).entity(newStack).execute();
    }

    @Override
    public Stack create(String name, String template, Map<String, String> parameters, boolean disableRollback, Long timeoutMins) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(template);
        Objects.requireNonNull(parameters);
        Objects.requireNonNull(timeoutMins);
        return this.create((StackCreate)Builders.stack().name(name).template(template).parameters(parameters).timeoutMins(timeoutMins).build());
    }

    @Override
    public List<? extends Stack> list() {
        return this.get(HeatStack.Stacks.class, this.uri("/stacks", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Stack> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<HeatStack.Stacks> req = this.get(HeatStack.Stacks.class, this.uri("/stacks", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public ActionResponse delete(String stackName, String stackId) {
        Objects.requireNonNull(stackId);
        return this.deleteWithResponse(this.uri("/stacks/%s/%s", stackName, stackId)).execute();
    }

    @Override
    public Stack getDetails(String stackName, String stackId) {
        Objects.requireNonNull(stackName);
        Objects.requireNonNull(stackId);
        return this.get(HeatStack.class, this.uri("/stacks/%s/%s", stackName, stackId)).execute();
    }

    @Override
    public ActionResponse update(String stackName, String stackId, StackUpdate stackUpdate) {
        Objects.requireNonNull(stackName);
        Objects.requireNonNull(stackId);
        Objects.requireNonNull(stackUpdate);
        return ToActionResponseFunction.INSTANCE.apply(this.put(Void.class, this.uri("/stacks/%s/%s", stackName, stackId)).entity(stackUpdate).executeWithResponse());
    }

    @Override
    public Stack getStackByName(String stackName) {
        Objects.requireNonNull(stackName);
        return this.get(HeatStack.class, this.uri("/stacks/%s", stackName)).execute();
    }

    @Override
    public AdoptStackData abandon(String stackName, String stackId) {
        Objects.requireNonNull(stackId);
        return this.delete(HeatAdoptStackData.class, this.uri("/stacks/%s/%s/abandon", stackName, stackId)).execute();
    }

    @Override
    public Stack adopt(AdoptStackData adoptStackData, Map<String, String> parameters, boolean disableRollback, Long timeoutMins, String template) {
        Objects.requireNonNull(adoptStackData);
        Objects.requireNonNull(parameters);
        Objects.requireNonNull(timeoutMins);
        HeatStackAdopt heatStackAdopt = HeatStackAdopt.builder().adoptStackData(adoptStackData).template(template).disableRollback(disableRollback).name(adoptStackData.getName()).parameters(parameters).timeoutMins(timeoutMins).build();
        return this.post(HeatStack.class, this.uri("/stacks", new Object[0])).entity(heatStackAdopt).execute();
    }
}

