/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.openstack4j.model.identity.v2.Endpoint;
import org.openstack4j.model.identity.v2.builder.EndpointBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystoneEndpoint
implements Endpoint {
    private static final long serialVersionUID = 1L;
    private String type;
    private String id;
    private String name;
    private String region;
    private URI publicURL;
    private URI internalURL;
    private URI adminURL;
    private String tenantId;
    private String versionId;
    private URI versionInfo;
    private URI versionList;

    public static EndpointBuilder builder() {
        return new EndPointConcreteBuilder();
    }

    @Override
    public EndpointBuilder toBuilder() {
        return new EndPointConcreteBuilder(this);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getAdminURL() {
        return this.adminURL;
    }

    @Override
    public URI getPublicURL() {
        return this.publicURL;
    }

    @Override
    public URI getInternalURL() {
        return this.internalURL;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public URI getVersionInfo() {
        return this.versionInfo;
    }

    @Override
    public URI getVersionList() {
        return this.versionList;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.versionId, this.region, this.publicURL, this.internalURL, this.adminURL, this.versionInfo, this.versionList, this.tenantId, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoneEndpoint that = (KeystoneEndpoint)KeystoneEndpoint.class.cast(obj);
        return Objects.equals(this.id, that.id) && Objects.equals(this.versionId, that.versionId) && Objects.equals(this.region, that.region) && Objects.equals(this.publicURL, that.publicURL) && Objects.equals(this.internalURL, that.internalURL) && Objects.equals(this.adminURL, that.adminURL) && Objects.equals(this.versionInfo, that.versionInfo) && Objects.equals(this.versionList, that.versionList) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.type, that.type);
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("name", this.name).add("type", this.type).add("region", this.region).add("publicURL", this.publicURL).add("internalURL", this.internalURL).add("adminURL", this.adminURL).add("versionId", this.versionId).add("versionInfo", this.versionInfo).add("versionList", this.versionList).toString();
    }

    public static class EndPointConcreteBuilder
    implements EndpointBuilder {
        protected KeystoneEndpoint model;

        protected EndPointConcreteBuilder() {
            this(new KeystoneEndpoint());
        }

        EndPointConcreteBuilder(KeystoneEndpoint model) {
            this.model = model;
        }

        @Override
        public EndpointBuilder region(String region) {
            this.model.region = region;
            return this;
        }

        @Override
        public EndpointBuilder publicURL(URI publicURL) {
            this.model.publicURL = publicURL;
            return this;
        }

        @Override
        public EndpointBuilder internalURL(URI internalURL) {
            this.model.internalURL = internalURL;
            return this;
        }

        @Override
        public EndpointBuilder tenantId(String tenantId) {
            this.model.tenantId = tenantId;
            return this;
        }

        @Override
        public EndpointBuilder type(String type) {
            this.model.type = type;
            return this;
        }

        @Override
        public EndpointBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public EndpointBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public EndpointBuilder adminURL(URI adminURL) {
            this.model.adminURL = adminURL;
            return this;
        }

        @Override
        public EndpointBuilder versionInfo(URI versionInfo) {
            this.model.versionInfo = versionInfo;
            return this;
        }

        @Override
        public EndpointBuilder versionList(URI versionList) {
            this.model.versionList = versionList;
            return this;
        }

        @Override
        public KeystoneEndpoint build() {
            return this.model;
        }

        @Override
        public EndpointBuilder from(Endpoint in) {
            this.model = (KeystoneEndpoint)in;
            return this;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Endpoints
    extends ListResult<KeystoneEndpoint> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="endpoints")
        private List<KeystoneEndpoint> endpoints;

        @Override
        public List<KeystoneEndpoint> value() {
            return this.endpoints;
        }
    }
}

