/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import org.openstack4j.model.identity.v2.ServiceEndpoint;
import org.openstack4j.model.identity.v2.builder.ServiceEndpointBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="endpoint")
public class KeystoneServiceEndpoint
implements ServiceEndpoint {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="region")
    private String region;
    @JsonProperty(value="service_id")
    private String serviceId;
    @JsonProperty(value="publicurl")
    private URI publicURL;
    @JsonProperty(value="adminurl")
    private URI adminURL;
    @JsonProperty(value="internalurl")
    private URI internalURL;

    public static ServiceEndpointBuilder builder() {
        return new ServiceConcreteEndpointBuilder();
    }

    @Override
    public ServiceEndpointBuilder toBuilder() {
        return new ServiceConcreteEndpointBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public URI getPublicURL() {
        return this.publicURL;
    }

    @Override
    public URI getAdminURL() {
        return this.adminURL;
    }

    @Override
    public URI getInternalURL() {
        return this.internalURL;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.region, this.publicURL, this.internalURL, this.adminURL, this.serviceId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoneServiceEndpoint that = (KeystoneServiceEndpoint)KeystoneServiceEndpoint.class.cast(obj);
        return Objects.equals(this.id, that.id) && Objects.equals(this.publicURL, that.publicURL) && Objects.equals(this.region, that.region) && Objects.equals(this.internalURL, that.internalURL) && Objects.equals(this.adminURL, that.adminURL) && Objects.equals(this.serviceId, that.serviceId);
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("region", this.region).add("publicURL", this.publicURL).add("internalURL", this.internalURL).add("adminURL", this.adminURL).add("serviceId", this.serviceId).toString();
    }

    public static class ServiceConcreteEndpointBuilder
    implements ServiceEndpointBuilder {
        private KeystoneServiceEndpoint model;

        ServiceConcreteEndpointBuilder() {
            this(new KeystoneServiceEndpoint());
        }

        ServiceConcreteEndpointBuilder(KeystoneServiceEndpoint model) {
            this.model = model;
        }

        @Override
        public ServiceEndpointBuilder region(String region) {
            this.model.region = region;
            return this;
        }

        @Override
        public ServiceEndpointBuilder serviceId(String serviceId) {
            this.model.serviceId = serviceId;
            return this;
        }

        @Override
        public ServiceEndpointBuilder publicURL(String publicURL) {
            this.model.publicURL = this.uri(publicURL);
            return this;
        }

        @Override
        public ServiceEndpointBuilder adminURL(String adminURL) {
            this.model.adminURL = this.uri(adminURL);
            return this;
        }

        @Override
        public ServiceEndpointBuilder internalURL(String internalURL) {
            this.model.internalURL = this.uri(internalURL);
            return this;
        }

        private URI uri(String url) {
            if (url == null) {
                return null;
            }
            try {
                return new URI(url);
            }
            catch (URISyntaxException e) {
                LoggerFactory.getLogger(ServiceConcreteEndpointBuilder.class).error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        @Override
        public ServiceEndpoint build() {
            return this.model;
        }

        @Override
        public ServiceEndpointBuilder from(ServiceEndpoint in) {
            this.model = (KeystoneServiceEndpoint)in;
            return this;
        }
    }

    public static class ServiceEndpoints
    extends ListResult<KeystoneServiceEndpoint> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="endpoints")
        List<KeystoneServiceEndpoint> endpoints;

        @Override
        public List<KeystoneServiceEndpoint> value() {
            return this.endpoints;
        }
    }
}

