/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import org.openstack4j.model.identity.v2.Role;
import org.openstack4j.model.identity.v2.Tenant;
import org.openstack4j.model.identity.v2.User;
import org.openstack4j.model.identity.v2.builder.UserBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.identity.v2.domain.KeystoneRole;
import org.openstack4j.util.ToStringHelper;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="user")
public class KeystoneUser
implements User {
    private static final long serialVersionUID = 1L;
    private String id;
    private String username;
    @JsonProperty(value="password")
    private String password;
    private String tenantId;
    private String name;
    private String email;
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="OS-ROLE:roles")
    private List<KeystoneRole> roles;

    public static UserBuilder builder() {
        return new UserConcreteBuilder();
    }

    @Override
    public UserBuilder toBuilder() {
        return new UserConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public Boolean isEnabled() {
        return this.enabled;
    }

    public List<? extends Role> getRoles() {
        return this.roles;
    }

    public String toString() {
        return new ToStringHelper(this).add("name", this.name).add("id", this.id).add("username", this.username).add("password", this.password).add("tenantId", this.tenantId).add("email", this.email).add("enabled", this.enabled).add("roles", this.roles).toString();
    }

    public static class UserConcreteBuilder
    implements UserBuilder {
        private KeystoneUser model;

        UserConcreteBuilder() {
            this(new KeystoneUser());
        }

        UserConcreteBuilder(KeystoneUser model) {
            this.model = model;
        }

        @Override
        public UserBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public UserBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public UserBuilder password(String password) {
            this.model.password = password;
            return this;
        }

        @Override
        public UserBuilder email(String email) {
            this.model.email = email;
            return this;
        }

        @Override
        public UserBuilder enabled(boolean enabled) {
            this.model.enabled = enabled;
            return this;
        }

        @Override
        public UserBuilder tenantId(String tenantId) {
            this.model.tenantId = tenantId;
            return this;
        }

        @Override
        public UserBuilder tenant(Tenant tenant) {
            if (tenant != null && tenant.getId() != null) {
                this.model.tenantId = tenant.getId();
            }
            return this;
        }

        @Override
        public User build() {
            return this.model;
        }

        @Override
        public UserBuilder from(User in) {
            this.model = (KeystoneUser)in;
            return this;
        }
    }

    public static class Users
    extends ListResult<KeystoneUser> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="users")
        private List<KeystoneUser> list;

        @Override
        public List<KeystoneUser> value() {
            return this.list;
        }
    }
}

