/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v2.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.identity.v2.ServiceManagerService;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v2.Service;
import org.openstack4j.model.identity.v2.ServiceEndpoint;
import org.openstack4j.openstack.identity.v2.domain.KeystoneService;
import org.openstack4j.openstack.identity.v2.domain.KeystoneServiceEndpoint;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class ServiceManagerServiceImpl
extends BaseOpenStackService
implements ServiceManagerService {
    @Override
    public List<? extends Service> list() {
        return this.get(KeystoneService.Services.class, this.uri("/OS-KSADM/services", new Object[0])).execute().getList();
    }

    @Override
    public Service get(String serviceId) {
        Objects.requireNonNull(serviceId);
        return this.get(KeystoneService.class, this.uri("/OS-KSADM/services/%s", serviceId)).execute();
    }

    @Override
    public Service create(String name, String type, String description) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(type);
        Objects.requireNonNull(description);
        return this.post(KeystoneService.class, this.uri("/OS-KSADM/services", new Object[0])).entity((ModelEntity)KeystoneService.builder().name(name).type(type).description(description).build()).execute();
    }

    @Override
    public ActionResponse delete(String serviceId) {
        Objects.requireNonNull(serviceId);
        return this.deleteWithResponse(this.uri("/OS-KSADM/services/%s", serviceId)).execute();
    }

    @Override
    public List<? extends ServiceEndpoint> listEndpoints() {
        return this.get(KeystoneServiceEndpoint.ServiceEndpoints.class, this.uri("/endpoints", new Object[0])).execute().getList();
    }

    @Override
    public ServiceEndpoint createEndpoint(String region, String serviceId, String publicURL, String adminURL, String internalURL) {
        Objects.requireNonNull(region);
        Objects.requireNonNull(serviceId);
        Objects.requireNonNull(publicURL);
        Objects.requireNonNull(adminURL);
        Objects.requireNonNull(internalURL);
        return this.post(KeystoneServiceEndpoint.class, this.uri("/endpoints", new Object[0])).entity((ModelEntity)KeystoneServiceEndpoint.builder().region(region).serviceId(serviceId).publicURL(publicURL).adminURL(adminURL).internalURL(internalURL).build()).execute();
    }

    @Override
    public ActionResponse deleteEndpoint(String endpointId) {
        Objects.requireNonNull(endpointId);
        return this.deleteWithResponse(this.uri("/endpoints/%s", endpointId)).execute();
    }
}

