/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v2.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.Apis;
import org.openstack4j.api.identity.v2.UserService;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v2.Role;
import org.openstack4j.model.identity.v2.User;
import org.openstack4j.openstack.identity.v2.domain.KeystoneUser;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class UserServiceImpl
extends BaseOpenStackService
implements UserService {
    @Override
    public List<? extends User> list() {
        return this.get(KeystoneUser.Users.class, this.uri("/users", new Object[0])).execute().getList();
    }

    @Override
    public User get(String userId) {
        Objects.requireNonNull(userId);
        return this.get(KeystoneUser.class, this.uri("/users/%s", userId)).execute();
    }

    @Override
    public List<? extends User> listTenantUsers(String tenantId) {
        Objects.requireNonNull(tenantId);
        return this.get(KeystoneUser.Users.class, this.uri("/tenants/%s/users", tenantId)).execute().getList();
    }

    @Override
    public User create(String tenantId, String name, String password, String email, boolean enabled) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(password);
        return this.create((User)KeystoneUser.builder().name(name).tenantId(tenantId).email(email).password(password).enabled(enabled).build());
    }

    @Override
    public User create(User user) {
        Objects.requireNonNull(user);
        return this.post(KeystoneUser.class, this.uri("/users", new Object[0])).entity(user).execute();
    }

    @Override
    public ActionResponse delete(String userId) {
        Objects.requireNonNull(userId);
        return this.deleteWithResponse(this.uri("/users/%s", userId)).execute();
    }

    @Override
    public User enableUser(String userId, boolean enabled) {
        Objects.requireNonNull(userId);
        return this.put(KeystoneUser.class, this.uri("/users/%s/OS-KSADM/enabled", userId)).entity((ModelEntity)KeystoneUser.builder().enabled(enabled).build()).execute();
    }

    @Override
    public User update(User user) {
        Objects.requireNonNull(user);
        return this.put(KeystoneUser.class, this.uri("/users/%s", user.getId())).entity(user).execute();
    }

    @Override
    public ActionResponse changePassword(String userId, String password) {
        Objects.requireNonNull(userId);
        Objects.requireNonNull(password);
        return this.put(ActionResponse.class, this.uri("/users/%s/OS-KSADM/password", userId)).entity((ModelEntity)KeystoneUser.builder().id(userId).password(password).build()).execute();
    }

    @Override
    public List<? extends Role> listRoles(String userId) {
        Objects.requireNonNull(userId);
        return Apis.getIdentityV2Services().roles().listRolesForUser(userId);
    }

    @Override
    public List<? extends Role> listRoles(User user) {
        Objects.requireNonNull(user);
        return this.listRoles(user.getId());
    }

    @Override
    public List<? extends Role> listRolesOnTenant(String userId, String tenantId) {
        return Apis.getIdentityV2Services().roles().listRolesForUser(userId, tenantId);
    }

    @Override
    public List<? extends Role> listRolesOnCurrentTenant(User user) {
        Objects.requireNonNull(user);
        return Apis.getIdentityV2Services().roles().listRolesForUser(user.getId(), user.getTenantId());
    }

    @Override
    public User getByName(String userName) {
        Objects.requireNonNull(userName);
        return this.get(KeystoneUser.class, "/users").param("name", userName).execute();
    }
}

