/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.model.identity.v3.Credential;
import org.openstack4j.model.identity.v3.builder.CredentialBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="credential")
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystoneCredential
implements Credential {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="project_id")
    private String projectId;
    private String type;
    private String blob;
    private Map<String, String> links;

    public static CredentialBuilder builder() {
        return new CredentialConcreteBuilder();
    }

    @Override
    public CredentialBuilder toBuilder() {
        return new CredentialConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getBlob() {
        return this.blob;
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("userId", this.userId).add("projectId", this.projectId).add("type", this.type).add("blob", this.blob).add("links", this.links).toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userId, this.projectId, this.type, this.blob, this.links);
    }

    public static class Credentials
    extends ListResult<KeystoneCredential> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="credentials")
        protected List<KeystoneCredential> list;

        @Override
        protected List<KeystoneCredential> value() {
            return this.list;
        }
    }

    public static class CredentialConcreteBuilder
    implements CredentialBuilder {
        KeystoneCredential model;

        public CredentialConcreteBuilder() {
            this(new KeystoneCredential());
        }

        CredentialConcreteBuilder(KeystoneCredential model) {
            this.model = model;
        }

        @Override
        public Credential build() {
            return this.model;
        }

        @Override
        public CredentialBuilder from(Credential in) {
            if (in != null) {
                this.model = (KeystoneCredential)in;
            }
            return this;
        }

        @Override
        public CredentialBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public CredentialBuilder userId(String userId) {
            this.model.userId = userId;
            return this;
        }

        @Override
        public CredentialBuilder projectId(String projectId) {
            this.model.projectId = projectId;
            return this;
        }

        @Override
        public CredentialBuilder type(String type) {
            this.model.type = type;
            return this;
        }

        @Override
        public CredentialBuilder blob(String blob) {
            this.model.blob = blob;
            return this;
        }

        @Override
        public CredentialBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }
    }
}

