/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import java.util.Objects;
import org.openstack4j.model.identity.v3.Region;
import org.openstack4j.model.identity.v3.builder.RegionBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="region")
public class KeystoneRegion
implements Region {
    private static final long serialVersionUID = 1L;
    private String id;
    private String description;
    @JsonProperty(value="parent_region_id")
    private String parentRegionId;

    public static RegionBuilder builder() {
        return new RegionConcreteBuilder();
    }

    @Override
    public RegionBuilder toBuilder() {
        return new RegionConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getParentRegionId() {
        return this.parentRegionId;
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("description", this.description).add("parentRegionId", this.parentRegionId).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoneRegion that = (KeystoneRegion)KeystoneRegion.class.cast(obj);
        return Objects.equals(this.id, that.id) && Objects.equals(this.description, that.description) && Objects.equals(this.parentRegionId, that.parentRegionId);
    }

    public static class RegionConcreteBuilder
    implements RegionBuilder {
        KeystoneRegion model;

        RegionConcreteBuilder() {
            this(new KeystoneRegion());
        }

        RegionConcreteBuilder(KeystoneRegion model) {
            this.model = model;
        }

        @Override
        public RegionBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public Region build() {
            return this.model;
        }

        @Override
        public RegionBuilder from(Region in) {
            if (in != null) {
                this.model = (KeystoneRegion)in;
            }
            return this;
        }

        @Override
        public RegionBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public RegionBuilder parentRegionId(String parentRegionId) {
            this.model.parentRegionId = parentRegionId;
            return this;
        }
    }

    public static class Regions
    extends ListResult<KeystoneRegion> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="regions")
        private List<KeystoneRegion> list;

        @Override
        public List<KeystoneRegion> value() {
            return this.list;
        }
    }
}

