/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.identity.v3.Role;
import org.openstack4j.model.identity.v3.builder.RoleBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="role")
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystoneRole
implements Role {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty(value="domain_id")
    private String domainId;
    private Map<String, String> links;
    private Map<String, String> options = new HashMap<String, String>();

    public static RoleBuilder builder() {
        return new RoleConcreteBuilder();
    }

    @Override
    public RoleBuilder toBuilder() {
        return new RoleConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    public String toString() {
        return new ToStringHelper(this).add("id", this.id).add("name", this.name).add("domain_id", this.domainId).add("links", this.links).toString();
    }

    public static class Roles
    extends ListResult<KeystoneRole> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="roles")
        protected List<KeystoneRole> list;

        @Override
        public List<KeystoneRole> value() {
            return this.list;
        }
    }

    public static class RoleConcreteBuilder
    implements RoleBuilder {
        private KeystoneRole model;

        RoleConcreteBuilder() {
            this(new KeystoneRole());
        }

        RoleConcreteBuilder(KeystoneRole model) {
            this.model = model;
        }

        @Override
        public Role build() {
            return this.model;
        }

        @Override
        public RoleBuilder from(Role in) {
            this.model = (KeystoneRole)in;
            return this;
        }

        @Override
        public RoleBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public RoleBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public RoleBuilder domainId(String domainId) {
            this.model.domainId = domainId;
            return this;
        }

        @Override
        public RoleBuilder options(Map<String, String> options) {
            this.model.options = options;
            return this;
        }

        @Override
        public RoleBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }
    }
}

