/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import java.util.List;
import java.util.Objects;
import org.openstack4j.api.identity.v3.ProjectService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Project;
import org.openstack4j.openstack.identity.v3.domain.KeystoneProject;
import org.openstack4j.openstack.identity.v3.internal.BaseIdentityServices;

public class ProjectServiceImpl
extends BaseIdentityServices
implements ProjectService {
    @Override
    public Project create(Project project) {
        Objects.requireNonNull(project);
        return this.post(KeystoneProject.class, "/projects").entity(project).execute();
    }

    @Override
    public Project create(String domainId, String name, String description, boolean enabled) {
        Objects.requireNonNull(domainId);
        Objects.requireNonNull(name);
        Objects.requireNonNull(description);
        Objects.requireNonNull(enabled);
        return this.create((Project)KeystoneProject.builder().domainId(domainId).name(name).description(description).enabled(enabled).build());
    }

    @Override
    public Project get(String projectId) {
        Objects.requireNonNull(projectId);
        return this.get(KeystoneProject.class, "/projects", "/", projectId).execute();
    }

    @Override
    public List<? extends Project> getByName(String projectName) {
        Objects.requireNonNull(projectName);
        return this.get(KeystoneProject.Projects.class, this.uri("/projects", new Object[0])).param("name", projectName).execute().getList();
    }

    @Override
    public Project getByName(String projectName, String domainId) {
        Objects.requireNonNull(projectName);
        Objects.requireNonNull(domainId);
        return (Project)this.get(KeystoneProject.Projects.class, this.uri("/projects", new Object[0])).param("name", projectName).param("domain_id", domainId).execute().first();
    }

    @Override
    public Project update(Project project) {
        Objects.requireNonNull(project);
        return this.patch(KeystoneProject.class, "/projects", "/", project.getId()).entity(project).execute();
    }

    @Override
    public ActionResponse delete(String projectId) {
        Objects.requireNonNull(projectId);
        return this.deleteWithResponse("/projects", "/", projectId).execute();
    }

    @Override
    public List<? extends Project> list() {
        return this.get(KeystoneProject.Projects.class, this.uri("/projects", new Object[0])).execute().getList();
    }
}

