/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.openstack4j.api.identity.v3.ServiceEndpointService;
import org.openstack4j.api.types.Facing;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Endpoint;
import org.openstack4j.model.identity.v3.Service;
import org.openstack4j.openstack.identity.v3.domain.KeystoneEndpoint;
import org.openstack4j.openstack.identity.v3.domain.KeystoneService;
import org.openstack4j.openstack.identity.v3.internal.BaseIdentityServices;

public class ServiceEndpointServiceImpl
extends BaseIdentityServices
implements ServiceEndpointService {
    @Override
    public Service create(Service service) {
        Objects.requireNonNull(service);
        return this.post(KeystoneService.class, this.uri("/services", new Object[0])).entity(service).execute();
    }

    @Override
    public Service create(String type, String name, String description, boolean enabled) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(name);
        Objects.requireNonNull(description);
        Objects.requireNonNull(enabled);
        return this.create((Service)KeystoneService.builder().type(type).name(name).description(description).enabled(enabled).build());
    }

    @Override
    public Service get(String serviceId) {
        Objects.requireNonNull(serviceId);
        return this.get(KeystoneService.class, "/services", "/", serviceId).execute();
    }

    @Override
    public Service update(Service service) {
        Objects.requireNonNull(service);
        return this.patch(KeystoneService.class, "/services", "/", service.getId()).entity(service).execute();
    }

    @Override
    public ActionResponse delete(String serviceId) {
        Objects.requireNonNull(serviceId);
        return this.deleteWithResponse("/services", "/", serviceId).execute();
    }

    @Override
    public List<? extends Service> list() {
        return this.get(KeystoneService.Services.class, this.uri("/services", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Endpoint> listEndpoints() {
        return this.get(KeystoneEndpoint.Endpoints.class, this.uri("/endpoints", new Object[0])).execute().getList();
    }

    @Override
    public Endpoint createEndpoint(Endpoint endpoint) {
        Objects.requireNonNull(endpoint);
        return this.post(KeystoneEndpoint.class, this.uri("/endpoints", new Object[0])).entity(endpoint).execute();
    }

    @Override
    public Endpoint createEndpoint(String name, URL url, Facing iface, String regionId, String serviceId, boolean enabled) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(url);
        Objects.requireNonNull(iface);
        Objects.requireNonNull(regionId);
        Objects.requireNonNull(serviceId);
        Objects.requireNonNull(enabled);
        return this.createEndpoint((Endpoint)KeystoneEndpoint.builder().name(name).url(url).iface(iface).regionId(regionId).serviceId(serviceId).enabled(enabled).build());
    }

    @Override
    public Endpoint getEndpoint(String endpointId) {
        Objects.requireNonNull(endpointId);
        return this.get(KeystoneEndpoint.class, "/endpoints", "/", endpointId).execute();
    }

    @Override
    public Endpoint updateEndpoint(Endpoint endpoint) {
        Objects.requireNonNull(endpoint);
        return this.patch(KeystoneEndpoint.class, "/endpoints", "/", endpoint.getId()).entity(endpoint).execute();
    }

    @Override
    public ActionResponse deleteEndpoint(String endpointId) {
        Objects.requireNonNull(endpointId);
        return this.deleteWithResponse("/endpoints", "/", endpointId).execute();
    }
}

