/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.image.internal;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openstack4j.api.client.CloudProvider;
import org.openstack4j.api.exceptions.ResponseException;
import org.openstack4j.api.image.ImageService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.image.CachedImage;
import org.openstack4j.model.image.Image;
import org.openstack4j.model.image.ImageMember;
import org.openstack4j.openstack.image.domain.CachedGlanceImage;
import org.openstack4j.openstack.image.domain.GlanceImage;
import org.openstack4j.openstack.image.domain.GlanceImageMember;
import org.openstack4j.openstack.image.domain.functions.ImageForUpdateToHeaders;
import org.openstack4j.openstack.image.domain.functions.ImageFromHeadersFunction;
import org.openstack4j.openstack.image.internal.BaseImageServices;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class ImageServiceImpl
extends BaseImageServices
implements ImageService {
    private static final int DEFAULT_PAGE_SIZE = 25;

    @Override
    public List<? extends CachedImage> listChachedImages() {
        try {
            return this.get(CachedGlanceImage.CachedImages.class, this.uri("/cached_images", new Object[0])).execute(ExecutionOptions.create(PropagateOnStatus.on(404))).getList();
        }
        catch (ResponseException e) {
            return null;
        }
    }

    @Override
    public List<? extends Image> list() {
        String uri = this.getProvider() == CloudProvider.RACKSPACE ? "/images" : "/images/detail";
        return this.get(GlanceImage.Images.class, this.uri(uri, new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Image> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GlanceImage.Images> imageInvocation = this.buildInvocation(filteringParams);
        return imageInvocation.execute().getList();
    }

    @Override
    public List<? extends Image> listAll(Map<String, String> filteringParams) {
        List totalList;
        BaseOpenStackService.Invocation<GlanceImage.Images> imageInvocation = this.buildInvocation(filteringParams);
        int limit = 25;
        if (filteringParams != null && filteringParams.containsKey("limit")) {
            limit = Integer.parseInt(filteringParams.get("limit"));
        }
        List currList = totalList = imageInvocation.execute().getList();
        while (currList.size() == limit) {
            imageInvocation.updateParam("marker", ((GlanceImage)currList.get(limit - 1)).getId());
            currList = imageInvocation.execute().getList();
            totalList.addAll(currList);
        }
        return totalList;
    }

    @Override
    public List<? extends Image> listAll() {
        return this.listAll(null);
    }

    private BaseOpenStackService.Invocation<GlanceImage.Images> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GlanceImage.Images> imageInvocation = this.get(GlanceImage.Images.class, "/images/detail");
        if (filteringParams == null) {
            return imageInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                imageInvocation = imageInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return imageInvocation;
    }

    @Override
    public Image get(String imageId) {
        Objects.requireNonNull(imageId);
        return this.head(Image.class, this.uri("/images/%s", imageId)).execute(ExecutionOptions.create(ImageFromHeadersFunction.instance()));
    }

    @Override
    public ActionResponse delete(String imageId) {
        Objects.requireNonNull(imageId);
        return this.deleteWithResponse(this.uri("/images/%s", imageId)).param("format", "json").execute();
    }

    @Override
    public Image update(Image image) {
        Objects.requireNonNull(image);
        Objects.requireNonNull(image.getId());
        return this.put(GlanceImage.class, this.uri("/images/%s", image.getId())).headers(ImageForUpdateToHeaders.instance().apply(image)).execute();
    }

    @Override
    public InputStream getAsStream(String imageId) {
        Objects.requireNonNull(imageId);
        HttpResponse response = this.get(Void.class, this.uri("/images/%s", imageId)).header("Accept", "application/octet-stream").executeWithResponse();
        if (response.getStatus() < 400) {
            return response.getInputStream();
        }
        return null;
    }

    @Override
    public Image create(Image image, Payload<?> payload) {
        Objects.requireNonNull(image);
        if (payload == null) {
            return this.reserve(image);
        }
        return this.post(GlanceImage.class, this.uri("/images", new Object[0])).headers(ImageForUpdateToHeaders.instance().apply(image)).entity(payload).execute();
    }

    @Override
    public Image reserve(Image image) {
        Objects.requireNonNull(image);
        return this.post(GlanceImage.class, this.uri("/images", new Object[0])).headers(ImageForUpdateToHeaders.instance().apply(image)).execute();
    }

    @Override
    public Image upload(String imageId, Payload<?> payload, @Nullable Image image) {
        Objects.requireNonNull(imageId);
        Objects.requireNonNull(payload);
        return this.put(GlanceImage.class, this.uri("/images/%s", imageId)).headers(ImageForUpdateToHeaders.instance().apply(image)).entity(payload).execute();
    }

    @Override
    public List<? extends ImageMember> listMembers(String imageId) {
        Objects.requireNonNull(imageId);
        return this.get(GlanceImageMember.Members.class, this.uri("/images/%s/members", imageId)).execute().getList();
    }

    @Override
    public boolean addMember(String imageId, String tenantId) {
        Objects.requireNonNull(imageId);
        Objects.requireNonNull(tenantId);
        return HttpEntityHandler.statusAndClose(this.put(Void.class, this.uri("/images/%s/members/%s", imageId, tenantId)).executeWithResponse()) == 204;
    }

    @Override
    public boolean addMember(String imageId, String tenantId, boolean canShare) {
        Objects.requireNonNull(imageId);
        Objects.requireNonNull(tenantId);
        return HttpEntityHandler.statusAndClose(this.put(Void.class, this.uri("/images/%s/members/%s", imageId, tenantId)).entity(new GlanceImageMember(null, canShare)).executeWithResponse()) == 204;
    }

    @Override
    public boolean removeMember(String imageId, String tenantId) {
        Objects.requireNonNull(imageId);
        Objects.requireNonNull(tenantId);
        return HttpEntityHandler.statusAndClose(this.delete(Void.class, this.uri("/images/%s/members/%s", imageId, tenantId)).executeWithResponse()) == 204;
    }
}

