/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.image.v2.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.util.ToStringHelper;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PatchOperation
implements ModelEntity {
    private OperationType op;
    private String path;
    private Object value;

    public PatchOperation() {
    }

    public PatchOperation(OperationType op, String path, Object value) {
        this.op = op;
        this.path = path;
        this.value = value;
    }

    public PatchOperation(OperationType op, String path) {
        this.op = op;
        this.path = path;
    }

    public OperationType getOp() {
        return this.op;
    }

    public void setOp(OperationType op) {
        this.op = op;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        return new ToStringHelper(this).add("op", (Object)this.op).add("path", this.path).add("value", this.value).toString();
    }

    public static enum OperationType {
        ADD,
        REMOVE,
        REPLACE,
        UNKNOWN;


        @JsonCreator
        public static OperationType value(String v) {
            if (v == null) {
                return UNKNOWN;
            }
            try {
                return OperationType.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }
}

