/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.magnum;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.openstack4j.model.magnum.Cluster;
import org.openstack4j.model.magnum.ClusterBuilder;
import org.openstack4j.openstack.common.GenericLink;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MagnumCluster
implements Cluster {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="cluster_template_id")
    private String clusterTemplateId;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="links")
    private List<GenericLink> links;
    @JsonProperty(value="stack_id")
    private String stackId;
    @JsonProperty(value="master_count")
    private Integer masterCount;
    @JsonProperty(value="create_timeout")
    private Integer createTimeout;
    @JsonProperty(value="node_count")
    private Integer nodeCount;
    @JsonProperty(value="discovery_url")
    private String discoveryUrl;
    @JsonProperty(value="keypair")
    private String keypair;
    @JsonProperty(value="name")
    private String name;

    public static ClusterBuilder builder() {
        return new ClusterConcreteBuilder();
    }

    @Override
    public ClusterBuilder toBuilder() {
        return new ClusterConcreteBuilder(this);
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getClusterTemplateId() {
        return this.clusterTemplateId;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public List<GenericLink> getLinks() {
        return this.links;
    }

    @Override
    public String getStackId() {
        return this.stackId;
    }

    @Override
    public Integer getMasterCount() {
        return this.masterCount;
    }

    @Override
    public Integer getCreateTimeout() {
        return this.createTimeout;
    }

    @Override
    public Integer getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    @Override
    public String getKeypair() {
        return this.keypair;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return new ToStringHelper(this).add("status", this.status).add("clusterTemplateId", this.clusterTemplateId).add("uuid", this.uuid).add("links", this.links).add("stackId", this.stackId).add("masterCount", this.masterCount).add("createTimeout", this.createTimeout).add("nodeCount", this.nodeCount).add("discoveryUrl", this.discoveryUrl).add("keypair", this.keypair).add("name", this.name).toString();
    }

    public static class Clusters
    extends ListResult<MagnumCluster> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="clusters")
        private List<MagnumCluster> list;

        @Override
        public List<MagnumCluster> value() {
            return this.list;
        }
    }

    public static class ClusterConcreteBuilder
    implements ClusterBuilder {
        MagnumCluster model;

        public ClusterConcreteBuilder() {
            this(new MagnumCluster());
        }

        public ClusterConcreteBuilder(MagnumCluster model) {
            this.model = model;
        }

        @Override
        public Cluster build() {
            return this.model;
        }

        @Override
        public ClusterBuilder from(Cluster in) {
            if (in != null) {
                this.model = (MagnumCluster)in;
            }
            return this;
        }

        @Override
        public ClusterBuilder status(String status) {
            this.model.status = status;
            return this;
        }

        @Override
        public ClusterBuilder clusterTemplateId(String clusterTemplateId) {
            this.model.clusterTemplateId = clusterTemplateId;
            return this;
        }

        @Override
        public ClusterBuilder uuid(String uuid) {
            this.model.uuid = uuid;
            return this;
        }

        @Override
        public ClusterBuilder links(List<GenericLink> links) {
            this.model.links = links;
            return this;
        }

        @Override
        public ClusterBuilder stackId(String stackId) {
            this.model.stackId = stackId;
            return this;
        }

        @Override
        public ClusterBuilder masterCount(Integer masterCount) {
            this.model.masterCount = masterCount;
            return this;
        }

        @Override
        public ClusterBuilder createTimeout(Integer createTimeout) {
            this.model.createTimeout = createTimeout;
            return this;
        }

        @Override
        public ClusterBuilder nodeCount(Integer nodeCount) {
            this.model.nodeCount = nodeCount;
            return this;
        }

        @Override
        public ClusterBuilder discoveryUrl(String discoveryUrl) {
            this.model.discoveryUrl = discoveryUrl;
            return this;
        }

        @Override
        public ClusterBuilder keypair(String keypair) {
            this.model.keypair = keypair;
            return this;
        }

        @Override
        public ClusterBuilder name(String name) {
            this.model.name = name;
            return this;
        }
    }
}

