/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import org.openstack4j.model.network.NetQuota;
import org.openstack4j.model.network.builder.NetQuotaBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="quota")
public class NeutronNetQuota
implements NetQuota {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private int subnet;
    @JsonProperty
    private int router;
    @JsonProperty
    private int port;
    @JsonProperty
    private int network;
    @JsonProperty(value="floatingip")
    private int floatingIp;
    @JsonProperty(value="security_group")
    private int securityGroup;
    @JsonProperty(value="security_group_rule")
    private int securityGroupRule;
    @JsonProperty(value="subnetpool")
    private int subnetpool;
    @JsonProperty(value="rbac_policy")
    private int rbacPolicy;

    public static NetQuotaBuilder builder() {
        return new NetQuotaConcreteBuilder();
    }

    @Override
    public NetQuotaBuilder toBuilder() {
        return new NetQuotaConcreteBuilder(this);
    }

    @Override
    public int getSubnet() {
        return this.subnet;
    }

    @Override
    public int getRouter() {
        return this.router;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getNetwork() {
        return this.network;
    }

    @Override
    @JsonIgnore
    public int getFloatingIP() {
        return this.floatingIp;
    }

    @Override
    public int getSecurityGroup() {
        return this.securityGroup;
    }

    @Override
    public int getSubnetpool() {
        return this.subnetpool;
    }

    @Override
    public int getRbacPolicy() {
        return this.rbacPolicy;
    }

    @Override
    public int getSecurityGroupRule() {
        return this.securityGroupRule;
    }

    public String toString() {
        return new ToStringHelper(this).add("subnet", this.subnet).add("router", this.router).add("port", this.port).add("network", this.network).add("floatingIp", this.floatingIp).add("subnetpool", this.subnetpool).add("rbacPolicy", this.rbacPolicy).toString();
    }

    public static class NeutronNetQuotas
    extends ListResult<NeutronNetQuota> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="quotas")
        private List<NeutronNetQuota> quotas;

        @Override
        protected List<NeutronNetQuota> value() {
            return this.quotas;
        }
    }

    public static class NetQuotaConcreteBuilder
    implements NetQuotaBuilder {
        private NeutronNetQuota model;

        public NetQuotaConcreteBuilder() {
            this.model = new NeutronNetQuota();
        }

        public NetQuotaConcreteBuilder(NeutronNetQuota model) {
            this.model = model;
        }

        @Override
        public NetQuota build() {
            return this.model;
        }

        @Override
        public NetQuotaBuilder from(NetQuota in) {
            this.model = (NeutronNetQuota)in;
            return this;
        }

        @Override
        public NetQuotaBuilder subnet(int subnet) {
            this.model.subnet = subnet;
            return this;
        }

        @Override
        public NetQuotaBuilder router(int router) {
            this.model.router = router;
            return this;
        }

        @Override
        public NetQuotaBuilder port(int port) {
            this.model.port = port;
            return this;
        }

        @Override
        public NetQuotaBuilder network(int network) {
            this.model.network = network;
            return this;
        }

        @Override
        public NetQuotaBuilder floatingIP(int floatingIP) {
            this.model.floatingIp = floatingIP;
            return this;
        }

        @Override
        public NetQuotaBuilder securityGroup(int securityGroup) {
            this.model.securityGroup = securityGroup;
            return this;
        }

        @Override
        public NetQuotaBuilder securityGroupRule(int securityGroupRule) {
            this.model.securityGroupRule = securityGroupRule;
            return this;
        }

        @Override
        public NetQuotaBuilder subnetpool(int subnetpool) {
            this.model.subnetpool = subnetpool;
            return this;
        }

        @Override
        public NetQuotaBuilder rbacPolicy(int rbacPolicy) {
            this.model.rbacPolicy = rbacPolicy;
            return this;
        }
    }
}

