/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.openstack4j.model.network.NetworkUpdate;
import org.openstack4j.model.network.builder.NetworkUpdateBuilder;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="network")
public class NeutronNetworkUpdate
implements NetworkUpdate {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String name;
    @JsonProperty(value="shared")
    private Boolean shared;
    @JsonProperty(value="admin_state_up")
    private Boolean adminStateUp;
    @JsonProperty(value="is_default")
    private Boolean isDefault;

    public static NetworkUpdateBuilder builder() {
        return new NetworkUpdateConcreteBuilder();
    }

    @Override
    public NetworkUpdateBuilder toBuilder() {
        return new NetworkUpdateConcreteBuilder(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public boolean isAdminStateUp() {
        return this.adminStateUp == null ? false : this.adminStateUp;
    }

    @Override
    @JsonIgnore
    public boolean isShared() {
        return this.shared == null ? false : this.shared;
    }

    @Override
    @JsonIgnore
    public boolean isDefault() {
        return this.isDefault == null ? false : this.isDefault;
    }

    public String toString() {
        return new ToStringHelper(this).add("name", this.name).add("adminStateUp", this.adminStateUp).add("shared", this.shared).add("isDefault", this.isDefault).toString();
    }

    public static class NetworkUpdateConcreteBuilder
    implements NetworkUpdateBuilder {
        private NeutronNetworkUpdate model;

        public NetworkUpdateConcreteBuilder() {
            this.model = new NeutronNetworkUpdate();
        }

        public NetworkUpdateConcreteBuilder(NeutronNetworkUpdate model) {
            this.model = model;
        }

        @Override
        public NetworkUpdate build() {
            return this.model;
        }

        @Override
        public NetworkUpdateBuilder from(NetworkUpdate in) {
            this.model = (NeutronNetworkUpdate)in;
            return this;
        }

        @Override
        public NetworkUpdateBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public NetworkUpdateBuilder adminStateUp(boolean enabled) {
            this.model.adminStateUp = enabled;
            return this;
        }

        @Override
        public NetworkUpdateBuilder shared(boolean shared) {
            this.model.shared = shared;
            return this;
        }

        @Override
        public NetworkUpdateBuilder isDefault(boolean isDefault) {
            this.model.isDefault = isDefault;
            return this;
        }
    }
}

