/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import java.util.Objects;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.builder.ResourceBuilder;
import org.openstack4j.model.network.TrunkSubport;
import org.openstack4j.model.network.builder.TrunkSubportBuilder;
import org.openstack4j.openstack.common.ListEntity;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="sub_port")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronTrunkSubport
implements TrunkSubport,
ModelEntity {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="port_id")
    private String portId;
    @JsonProperty(value="segmentation_id")
    private int segmentationId;
    @JsonProperty(value="segmentation_type")
    private String segmentationType;

    public NeutronTrunkSubport() {
    }

    public NeutronTrunkSubport(String portId) {
        this.portId = portId;
    }

    public static TrunkSubportBuilder builder() {
        return new TrunkSubportConcreteBuilder();
    }

    public static NeutronTrunkSubport fromTrunkSubport(TrunkSubport trunkSubport) {
        NeutronTrunkSubport toCreate = new NeutronTrunkSubport();
        toCreate.portId = trunkSubport.getPortId();
        toCreate.segmentationId = trunkSubport.getSegmentationId();
        toCreate.segmentationType = trunkSubport.getSegmentationType();
        return toCreate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NeutronTrunkSubport) {
            NeutronTrunkSubport that = (NeutronTrunkSubport)obj;
            if (Objects.equals(this.portId, that.portId) && Objects.equals(this.segmentationId, that.segmentationId) && Objects.equals(this.segmentationType, that.segmentationType)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public String getId() {
        return this.portId;
    }

    @Override
    @Deprecated
    public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPortId() {
        return this.portId;
    }

    @Override
    public int getSegmentationId() {
        return this.segmentationId;
    }

    @Override
    public String getSegmentationType() {
        return this.segmentationType;
    }

    @Override
    @Deprecated
    public String getTenantId() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setTenantId(String tenantId) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hash(this.segmentationId, this.portId, this.segmentationType);
    }

    @Override
    public TrunkSubportBuilder toBuilder() {
        return new TrunkSubportConcreteBuilder(this);
    }

    public String toString() {
        return new ToStringHelper(this).add("segmentationId", this.segmentationId).add("portId", this.portId).add("segmentationType", this.segmentationType).toString();
    }

    public static class TrunkSubports
    extends ListResult<NeutronTrunkSubport> {
        private static final long serialVersionUID = 1L;
        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonProperty(value="sub_ports")
        private List<NeutronTrunkSubport> trunkSubports;

        @Override
        protected List<NeutronTrunkSubport> value() {
            return this.trunkSubports;
        }
    }

    public static class TrunkSubportConcreteBuilder
    extends ResourceBuilder<TrunkSubport, TrunkSubportConcreteBuilder>
    implements TrunkSubportBuilder {
        private NeutronTrunkSubport reference;

        TrunkSubportConcreteBuilder() {
            this(new NeutronTrunkSubport());
        }

        TrunkSubportConcreteBuilder(NeutronTrunkSubport trunkSubport) {
            this.reference = trunkSubport;
        }

        @Override
        public TrunkSubport build() {
            return this.reference;
        }

        @Override
        public TrunkSubportBuilder from(TrunkSubport in) {
            this.reference = (NeutronTrunkSubport)in;
            return this;
        }

        @Override
        public TrunkSubportBuilder portId(String portId) {
            this.reference.portId = portId;
            return this;
        }

        @Override
        protected TrunkSubport reference() {
            return this.reference;
        }

        @Override
        public TrunkSubportBuilder segmentationId(int segmentationId) {
            this.reference.segmentationId = segmentationId;
            return this;
        }

        @Override
        public TrunkSubportBuilder segmentationType(String segmentationType) {
            this.reference.segmentationType = segmentationType;
            return this;
        }
    }

    public static class NeutronTrunkSubports
    implements ModelEntity {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="sub_ports")
        private ListEntity<NeutronTrunkSubport> trunkSubports = new ListEntity();

        public static NeutronTrunkSubports fromTrunkSubports(List<? extends TrunkSubport> trunkSubports) {
            NeutronTrunkSubports toCreate = new NeutronTrunkSubports();
            for (TrunkSubport trunkSubport : trunkSubports) {
                toCreate.trunkSubports.add(NeutronTrunkSubport.fromTrunkSubport(trunkSubport));
            }
            return toCreate;
        }
    }
}

