/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import java.util.Objects;
import org.openstack4j.model.network.ext.PortForwarding;
import org.openstack4j.model.network.ext.builder.PortForwardingBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="port_forwarding")
@JsonIgnoreProperties(ignoreUnknown=true)
public class FloatingIPPortForwarding
implements PortForwarding {
    private static final long serialVersionUID = 1L;
    private String id;
    private String protocol;
    @JsonProperty(value="internal_ip_address")
    private String internalIpAddress;
    @JsonProperty(value="internal_port")
    private int internalPort;
    @JsonProperty(value="internal_port_id")
    private String internalPortId;
    @JsonProperty(value="external_port")
    private int externalPort;
    @JsonProperty(value="description")
    private String description;

    public static PortForwardingBuilder builder() {
        return new PortForwardingConcreteBuilder();
    }

    @Override
    public PortForwardingBuilder toBuilder() {
        return new PortForwardingConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getInternalIpAddress() {
        return this.internalIpAddress;
    }

    @Override
    public int getInternalPort() {
        return this.internalPort;
    }

    @Override
    public String getInternalPortId() {
        return this.internalPortId;
    }

    @Override
    public int getExternalPort() {
        return this.externalPort;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "NeutronPortForwarding{id='" + this.id + '\'' + ", protocol='" + this.protocol + '\'' + ", internalIpAddress='" + this.internalIpAddress + '\'' + ", internalPort=" + this.internalPort + ", internalPortId='" + this.internalPortId + '\'' + ", externalPort=" + this.externalPort + ", description='" + this.description + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatingIPPortForwarding that = (FloatingIPPortForwarding)o;
        return this.internalPort == that.internalPort && this.externalPort == that.externalPort && Objects.equals(this.id, that.id) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.internalIpAddress, that.internalIpAddress) && Objects.equals(this.internalPortId, that.internalPortId) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.protocol, this.internalIpAddress, this.internalPort, this.internalPortId, this.externalPort, this.description);
    }

    public static class PortForwardingConcreteBuilder
    implements PortForwardingBuilder {
        FloatingIPPortForwarding f;

        public PortForwardingConcreteBuilder() {
            this(new FloatingIPPortForwarding());
        }

        public PortForwardingConcreteBuilder(FloatingIPPortForwarding f) {
            this.f = f;
        }

        @Override
        public FloatingIPPortForwarding build() {
            return this.f;
        }

        @Override
        public PortForwardingConcreteBuilder from(PortForwarding in) {
            this.f = (FloatingIPPortForwarding)in;
            return this;
        }

        public PortForwardingConcreteBuilder id(String id) {
            this.f.id = id;
            return this;
        }

        @Override
        public PortForwardingConcreteBuilder description(String description) {
            this.f.description = description;
            return this;
        }

        @Override
        public PortForwardingConcreteBuilder protocol(String protocol) {
            this.f.protocol = protocol;
            return this;
        }

        @Override
        public PortForwardingConcreteBuilder internalIpAddress(String internalIpAddress) {
            this.f.internalIpAddress = internalIpAddress;
            return this;
        }

        @Override
        public PortForwardingConcreteBuilder internalPort(int internalPort) {
            this.f.internalPort = internalPort;
            return this;
        }

        @Override
        public PortForwardingConcreteBuilder internalPortId(String internalPortId) {
            this.f.internalPortId = internalPortId;
            return this;
        }

        @Override
        public PortForwardingConcreteBuilder externalPort(int externalPort) {
            this.f.externalPort = externalPort;
            return this;
        }
    }

    public static class PortForwardings
    extends ListResult<FloatingIPPortForwarding> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="port_forwardings")
        private List<FloatingIPPortForwarding> portForwardings;

        @Override
        protected List<FloatingIPPortForwarding> value() {
            return this.portForwardings;
        }
    }
}

