/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import org.openstack4j.model.network.ext.FirewallPolicyUpdate;
import org.openstack4j.model.network.ext.builder.FirewallPolicyUpdateBuilder;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="firewall_policy")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronFirewallPolicyUpdate
implements FirewallPolicyUpdate {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String description;
    private Boolean shared;
    private Boolean audited;
    @JsonProperty(value="firewall_rules")
    private List<String> firewallRules;

    public static FirewallPolicyUpdateBuilder builder() {
        return new FirewallPolicyUpdateConcreteBuilder();
    }

    @Override
    public FirewallPolicyUpdateBuilder toBuilder() {
        return new FirewallPolicyUpdateConcreteBuilder(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean isShared() {
        return this.shared != null && this.shared != false;
    }

    @Override
    public Boolean isAudited() {
        return this.audited != null && this.audited != false;
    }

    @Override
    @JsonIgnore
    public List<String> getFirewallRuleIds() {
        return this.firewallRules;
    }

    public String toString() {
        return new ToStringHelper(this).add("name", this.name).add("shared", this.shared).add("audited", this.audited).add("tenantId", this.tenantId).add("description", this.description).add("firewallRuleIds", this.firewallRules).toString();
    }

    public static class FirewallPolicyUpdateConcreteBuilder
    implements FirewallPolicyUpdateBuilder {
        NeutronFirewallPolicyUpdate f;

        public FirewallPolicyUpdateConcreteBuilder() {
            this(new NeutronFirewallPolicyUpdate());
        }

        public FirewallPolicyUpdateConcreteBuilder(NeutronFirewallPolicyUpdate f) {
            this.f = f;
        }

        @Override
        public FirewallPolicyUpdate build() {
            return this.f;
        }

        @Override
        public FirewallPolicyUpdateBuilder from(FirewallPolicyUpdate in) {
            this.f = (NeutronFirewallPolicyUpdate)in;
            return this;
        }

        @Override
        public FirewallPolicyUpdateBuilder name(String name) {
            this.f.name = name;
            return this;
        }

        @Override
        public FirewallPolicyUpdateBuilder description(String description) {
            this.f.description = description;
            return this;
        }

        @Override
        public FirewallPolicyUpdateBuilder shared(Boolean shared) {
            this.f.shared = shared;
            return this;
        }

        @Override
        public FirewallPolicyUpdateBuilder audited(Boolean audited) {
            this.f.audited = audited;
            return this;
        }

        @Override
        public FirewallPolicyUpdateBuilder firewallRules(List<String> ruleIdList) {
            this.f.firewallRules = ruleIdList;
            return this;
        }
    }
}

