/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.openstack4j.model.network.IPVersionType;
import org.openstack4j.model.network.ext.FirewallRuleUpdate;
import org.openstack4j.model.network.ext.builder.FirewallRuleUpdateBuilder;
import org.openstack4j.openstack.networking.domain.ext.NeutronFirewallRule;
import org.openstack4j.util.ToStringHelper;

@JsonRootName(value="firewall_rule")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronFirewallRuleUpdate
implements FirewallRuleUpdate {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String description;
    private Boolean enabled;
    private Boolean shared;
    private NeutronFirewallRule.FirewallRuleAction action;
    @JsonProperty(value="source_ip_address")
    private String sourceIpAddress;
    @JsonProperty(value="destination_ip_address")
    private String destinationIpAddress;
    private NeutronFirewallRule.IPProtocol protocol;
    @JsonProperty(value="ip_version")
    private IPVersionType ipVersion;
    @JsonProperty(value="source_port")
    private String sourcePort;
    @JsonProperty(value="destination_port")
    private String destinationPort;

    public static FirewallRuleUpdateBuilder builder() {
        return new FirewallRuleUpdateConcreteBuilder();
    }

    @Override
    public FirewallRuleUpdateBuilder toBuilder() {
        return new FirewallRuleUpdateConcreteBuilder(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean isShared() {
        return this.shared != null && this.shared != false;
    }

    @Override
    public NeutronFirewallRule.IPProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public IPVersionType getIpVersion() {
        return this.ipVersion;
    }

    @Override
    public String getSourceIpAddress() {
        return this.sourceIpAddress;
    }

    @Override
    public String getDestinationIpAddress() {
        return this.destinationIpAddress;
    }

    @Override
    public String getSourcePort() {
        return this.sourcePort;
    }

    @Override
    public String getDestinationPort() {
        return this.destinationPort;
    }

    @Override
    public NeutronFirewallRule.FirewallRuleAction getAction() {
        return this.action;
    }

    @Override
    public Boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public String toString() {
        return new ToStringHelper(this).add("name", this.name).add("action", (Object)this.action).add("ipVersion", (Object)this.ipVersion).add("enabled", this.enabled).add("shared", this.shared).add("tenantId", this.tenantId).add("sourceIpAddress", this.sourceIpAddress).add("destinationIpAddress", this.destinationIpAddress).add("sourcePort", this.sourcePort).add("destinationPort", this.destinationPort).add("description", this.description).add("protocol", (Object)this.protocol).toString();
    }

    public static class FirewallRuleUpdateConcreteBuilder
    implements FirewallRuleUpdateBuilder {
        NeutronFirewallRuleUpdate f;

        public FirewallRuleUpdateConcreteBuilder() {
            this(new NeutronFirewallRuleUpdate());
        }

        public FirewallRuleUpdateConcreteBuilder(NeutronFirewallRuleUpdate f) {
            this.f = f;
        }

        @Override
        public FirewallRuleUpdate build() {
            return this.f;
        }

        @Override
        public FirewallRuleUpdateBuilder from(FirewallRuleUpdate in) {
            this.f = (NeutronFirewallRuleUpdate)in;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder tenantId(String tenantId) {
            this.f.tenantId = tenantId;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder name(String name) {
            this.f.name = name;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder description(String description) {
            this.f.description = description;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder shared(Boolean shared) {
            this.f.shared = shared;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder protocol(NeutronFirewallRule.IPProtocol protocol) {
            this.f.protocol = protocol;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder ipVersion(IPVersionType ipVersion) {
            this.f.ipVersion = ipVersion;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder sourceIpAddress(String sourceIpAddress) {
            this.f.sourceIpAddress = sourceIpAddress;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder destinationIpAddress(String destinationIpAddress) {
            this.f.destinationIpAddress = destinationIpAddress;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder sourcePort(String sourcePort) {
            this.f.sourcePort = sourcePort;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder destinationPort(String destinationPort) {
            this.f.destinationPort = destinationPort;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder action(NeutronFirewallRule.FirewallRuleAction action) {
            this.f.action = action;
            return this;
        }

        @Override
        public FirewallRuleUpdateBuilder enabled(Boolean enabled) {
            this.f.enabled = enabled;
            return this;
        }
    }
}

